/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api;

import eu.decentsoftware.holograms.api.DecentHolograms;
import lombok.NonNull;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.ApiStatus;

public final class DecentHologramsAPI {
    private static DecentHolograms implementation;
    private static boolean enabled;

    @ApiStatus.Internal
    public static void onLoad(@NonNull JavaPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (implementation != null) {
            return;
        }
        implementation = new DecentHolograms(plugin);
        implementation.load();
    }

    @ApiStatus.Internal
    public static void onEnable() {
        if (implementation == null) {
            return;
        }
        enabled = true;
        implementation.enable();
    }

    @ApiStatus.Internal
    public static void onDisable() {
        if (implementation == null) {
            return;
        }
        implementation.disable();
        implementation = null;
        enabled = false;
    }

    public static boolean isRunning() {
        return implementation != null && enabled;
    }

    public static DecentHolograms get() {
        if (implementation == null || !enabled) {
            throw new IllegalStateException("DecentHolograms is not running (yet). Do you have DecentHolograms plugin installed?");
        }
        return implementation;
    }

    private DecentHologramsAPI() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        enabled = false;
    }
}

