/*
 * Decompiled with CFR 0.152.
 */
package eu.decentsoftware.holograms.api;

import eu.decentsoftware.holograms.api.Lang;
import eu.decentsoftware.holograms.api.Settings;
import eu.decentsoftware.holograms.api.animations.AnimationManager;
import eu.decentsoftware.holograms.api.commands.CommandManager;
import eu.decentsoftware.holograms.api.features.FeatureManager;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramManager;
import eu.decentsoftware.holograms.api.listeners.PlayerListener;
import eu.decentsoftware.holograms.api.listeners.WorldListener;
import eu.decentsoftware.holograms.api.nms.NMS;
import eu.decentsoftware.holograms.api.nms.PacketListener;
import eu.decentsoftware.holograms.api.utils.BungeeUtils;
import eu.decentsoftware.holograms.api.utils.Common;
import eu.decentsoftware.holograms.api.utils.DExecutor;
import eu.decentsoftware.holograms.api.utils.UpdateChecker;
import eu.decentsoftware.holograms.api.utils.event.EventFactory;
import eu.decentsoftware.holograms.api.utils.reflect.Version;
import eu.decentsoftware.holograms.api.utils.tick.Ticker;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import org.bstats.bukkit.Metrics;
import org.bstats.charts.CustomChart;
import org.bstats.charts.SingleLineChart;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;

public final class DecentHolograms {
    private final JavaPlugin plugin;
    private HologramManager hologramManager;
    private CommandManager commandManager;
    private FeatureManager featureManager;
    private AnimationManager animationManager;
    private PacketListener packetListener;
    private Ticker ticker;
    private boolean updateAvailable;

    DecentHolograms(@NonNull JavaPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        this.plugin = plugin;
    }

    void load() {
        if (Version.CURRENT == null) {
            Common.log(Level.SEVERE, "Unsupported server version: " + Bukkit.getServer().getVersion());
            Common.log(Level.SEVERE, "Plugin will be disabled.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.plugin);
        }
    }

    void enable() {
        NMS.init();
        Settings.reload();
        Lang.reload();
        DExecutor.init(3);
        this.ticker = new Ticker();
        this.hologramManager = new HologramManager(this);
        this.commandManager = new CommandManager();
        this.featureManager = new FeatureManager();
        this.animationManager = new AnimationManager(this);
        this.packetListener = new PacketListener(this);
        PluginManager pm = Bukkit.getPluginManager();
        pm.registerEvents((Listener)new PlayerListener(this), (Plugin)this.plugin);
        pm.registerEvents((Listener)new WorldListener(this), (Plugin)this.plugin);
        Metrics metrics = new Metrics(this.plugin, 12797);
        metrics.addCustomChart((CustomChart)new SingleLineChart("holograms", () -> Hologram.getCachedHolograms().size()));
        if (Settings.CHECK_FOR_UPDATES) {
            UpdateChecker updateChecker = new UpdateChecker(this.getPlugin(), 96927);
            updateChecker.getVersion(ver -> {
                if (Common.isVersionHigher(ver)) {
                    Lang.sendUpdateMessage((CommandSender)Bukkit.getConsoleSender());
                    this.updateAvailable = true;
                }
            });
        }
        BungeeUtils.init();
    }

    void disable() {
        this.packetListener.destroy();
        this.featureManager.destroy();
        this.hologramManager.destroy();
        this.animationManager.destroy();
        this.ticker.destroy();
        for (Hologram hologram : Hologram.getCachedHolograms()) {
            hologram.destroy();
        }
        BungeeUtils.destroy();
        DExecutor.shutdownNow();
    }

    public void reload() {
        Settings.reload();
        Lang.reload();
        this.animationManager.reload();
        this.hologramManager.reload();
        this.featureManager.reload();
        EventFactory.handleReloadEvent();
    }

    @Contract(pure=true)
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Contract(pure=true)
    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public JavaPlugin getPlugin() {
        return this.plugin;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public AnimationManager getAnimationManager() {
        return this.animationManager;
    }

    public PacketListener getPacketListener() {
        return this.packetListener;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }
}

