/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.expansion.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.cloud.CloudExpansion;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class CloudExpansionManager {
    @NotNull
    private static final String API_URL = "http://api.extendedclip.com/v2/";
    @NotNull
    private static final Gson GSON = new Gson();
    @NotNull
    private static final Type TYPE = new TypeToken<Map<String, CloudExpansion>>(){}.getType();
    @NotNull
    private final Collector<CloudExpansion, ?, Map<String, CloudExpansion>> INDEXED_NAME_COLLECTOR = Collectors.toMap(CloudExpansionManager::toIndexName, Function.identity());
    @NotNull
    private final PlaceholderAPIPlugin plugin;
    @NotNull
    private final Map<String, CloudExpansion> cache = new HashMap<String, CloudExpansion>();
    @NotNull
    private final Map<String, CompletableFuture<File>> await = new ConcurrentHashMap<String, CompletableFuture<File>>();
    private final ExecutorService ASYNC_EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("placeholderapi-io-#%1$d").build());

    public CloudExpansionManager(@NotNull PlaceholderAPIPlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    private static String toIndexName(@NotNull String name) {
        return name.toLowerCase(Locale.ROOT).replace(' ', '_');
    }

    @NotNull
    private static String toIndexName(@NotNull CloudExpansion expansion) {
        return CloudExpansionManager.toIndexName(expansion.getName());
    }

    public void load() {
        this.clean();
        this.fetch();
    }

    public void kill() {
        this.clean();
    }

    @NotNull
    public @Unmodifiable Map<String, CloudExpansion> getCloudExpansions() {
        return ImmutableMap.copyOf(this.cache);
    }

    @NotNull
    public @Unmodifiable Map<String, CloudExpansion> getCloudExpansionsInstalled() {
        if (this.cache.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.cache.values().stream().filter(CloudExpansion::hasExpansion).collect(this.INDEXED_NAME_COLLECTOR);
    }

    @NotNull
    public @Unmodifiable Map<String, CloudExpansion> getCloudExpansionsByAuthor(@NotNull String author) {
        if (this.cache.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.cache.values().stream().filter(expansion -> author.equalsIgnoreCase(expansion.getAuthor())).collect(this.INDEXED_NAME_COLLECTOR);
    }

    @NotNull
    public @Unmodifiable Set<String> getCloudExpansionAuthors() {
        return this.cache.values().stream().map(CloudExpansion::getAuthor).collect(Collectors.toSet());
    }

    public int getCloudExpansionAuthorCount() {
        return this.getCloudExpansionAuthors().size();
    }

    public int getCloudUpdateCount() {
        return (int)this.plugin.getLocalExpansionManager().getExpansions().stream().filter(expansion -> this.findCloudExpansionByName(expansion.getName()).map(CloudExpansion::shouldUpdate).orElse(false)).count();
    }

    @NotNull
    public Optional<CloudExpansion> findCloudExpansionByName(@NotNull String name) {
        return Optional.ofNullable(this.cache.get(CloudExpansionManager.toIndexName(name)));
    }

    public void clean() {
        this.cache.clear();
        this.await.values().forEach(future -> future.cancel(true));
        this.await.clear();
    }

    public void fetch() {
        this.plugin.getLogger().info("Fetching available expansion information...");
        this.ASYNC_EXECUTOR.submit(() -> {
            ConcurrentHashMap values = new ConcurrentHashMap();
            try {
                String json = Resources.toString((URL)new URL(API_URL), (Charset)StandardCharsets.UTF_8);
                values.putAll((Map)GSON.fromJson(json, TYPE));
                ArrayList<String> toRemove = new ArrayList<String>();
                for (Map.Entry entry : values.entrySet()) {
                    CloudExpansion expansion = (CloudExpansion)entry.getValue();
                    if (expansion.getLatestVersion() != null && expansion.getVersion(expansion.getLatestVersion()) != null) continue;
                    toRemove.add((String)entry.getKey());
                }
                for (String name : toRemove) {
                    values.remove(name);
                }
            }
            catch (Throwable e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to download expansion information", e);
            }
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                try {
                    for (Map.Entry entry : values.entrySet()) {
                        PlaceholderExpansion local;
                        String name = (String)entry.getKey();
                        CloudExpansion expansion = (CloudExpansion)entry.getValue();
                        expansion.setName(name);
                        Optional<PlaceholderExpansion> localOpt = this.plugin.getLocalExpansionManager().findExpansionByName(name);
                        if (localOpt.isPresent() && (local = localOpt.get()).isRegistered()) {
                            expansion.setHasExpansion(true);
                            expansion.setShouldUpdate(!local.getVersion().equalsIgnoreCase(expansion.getLatestVersion()));
                        }
                        this.cache.put(CloudExpansionManager.toIndexName(expansion), expansion);
                    }
                }
                catch (Throwable e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to download expansion information", e);
                }
            });
        });
    }

    public boolean isDownloading(@NotNull CloudExpansion expansion) {
        return this.await.containsKey(CloudExpansionManager.toIndexName(expansion));
    }

    @NotNull
    public CompletableFuture<File> downloadExpansion(@NotNull CloudExpansion expansion, @NotNull CloudExpansion.Version version) {
        CompletableFuture<File> previous = this.await.get(CloudExpansionManager.toIndexName(expansion));
        if (previous != null) {
            return previous;
        }
        File file = new File(this.plugin.getLocalExpansionManager().getExpansionsFolder(), "Expansion-" + CloudExpansionManager.toIndexName(expansion) + ".jar");
        CompletableFuture<File> download = CompletableFuture.supplyAsync(() -> {
            try (ReadableByteChannel source = Channels.newChannel(new URL(version.getUrl()).openStream());
                 FileOutputStream target = new FileOutputStream(file);){
                target.getChannel().transferFrom(source, 0L, Long.MAX_VALUE);
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
            return file;
        }, this.ASYNC_EXECUTOR);
        download.whenCompleteAsync((value, exception) -> {
            this.await.remove(CloudExpansionManager.toIndexName(expansion));
            if (exception != null) {
                Msg.severe("Failed to download %s:%s", exception, expansion.getName(), expansion.getVersion());
            }
        }, (Executor)this.ASYNC_EXECUTOR);
        this.await.put(CloudExpansionManager.toIndexName(expansion), download);
        return download;
    }
}

