/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi;

import dev.jorel.commandapi.CommandAPI;
import dev.jorel.commandapi.CommandAPIBukkit;
import dev.jorel.commandapi.LoadContext;
import dev.jorel.commandapi.exceptions.UnsupportedVersionException;
import dev.jorel.commandapi.nms.NMS_1_16_R3;
import dev.jorel.commandapi.nms.NMS_1_17;
import dev.jorel.commandapi.nms.NMS_1_17_R1;
import dev.jorel.commandapi.nms.NMS_1_18_R1;
import dev.jorel.commandapi.nms.NMS_1_18_R2;
import dev.jorel.commandapi.nms.NMS_1_19_1_R1;
import dev.jorel.commandapi.nms.NMS_1_19_3_R2;
import dev.jorel.commandapi.nms.NMS_1_19_4_R3;
import dev.jorel.commandapi.nms.NMS_1_19_R1;
import dev.jorel.commandapi.nms.NMS_1_20_R1;
import dev.jorel.commandapi.nms.NMS_1_20_R2;
import dev.jorel.commandapi.nms.NMS_1_20_R3;
import dev.jorel.commandapi.nms.NMS_1_20_R4;
import dev.jorel.commandapi.nms.NMS_1_21_R1;
import dev.jorel.commandapi.nms.NMS_1_21_R2;
import org.bukkit.Bukkit;

public interface CommandAPIVersionHandler {
    public static LoadContext getPlatform() {
        String currentMajorVersion;
        CommandAPIBukkit platform;
        String version;
        String latestMajorVersion = "21";
        if (CommandAPI.getConfiguration().shouldUseLatestNMSVersion()) {
            return new LoadContext(new NMS_1_21_R2(), () -> {
                CommandAPI.logWarning("Loading the CommandAPI with the latest and potentially incompatible NMS implementation.");
                CommandAPI.logWarning("While you may find success with this, further updates might be necessary to fully support the version you are using.");
            });
        }
        switch (version = Bukkit.getBukkitVersion().split("-")[0]) {
            case "1.16.5": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_16_R3();
                break;
            }
            case "1.17": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_17();
                break;
            }
            case "1.17.1": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_17_R1();
                break;
            }
            case "1.18": 
            case "1.18.1": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_18_R1();
                break;
            }
            case "1.18.2": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_18_R2();
                break;
            }
            case "1.19": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_19_R1();
                break;
            }
            case "1.19.1": 
            case "1.19.2": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_19_1_R1();
                break;
            }
            case "1.19.3": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_19_3_R2();
                break;
            }
            case "1.19.4": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_19_4_R3();
                break;
            }
            case "1.20": 
            case "1.20.1": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_20_R1();
                break;
            }
            case "1.20.2": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_20_R2();
                break;
            }
            case "1.20.3": 
            case "1.20.4": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_20_R3();
                break;
            }
            case "1.20.5": 
            case "1.20.6": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_20_R4();
                break;
            }
            case "1.21": 
            case "1.21.1": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_21_R1();
                break;
            }
            case "1.21.2": 
            case "1.21.3": {
                CommandAPIBukkit commandAPIBukkit = new NMS_1_21_R2();
                break;
            }
            default: {
                CommandAPIBukkit commandAPIBukkit = platform = null;
            }
        }
        if (platform != null) {
            return new LoadContext(platform);
        }
        if (CommandAPI.getConfiguration().shouldBeLenientForMinorVersions() && latestMajorVersion.equals(currentMajorVersion = version.split("\\.")[1])) {
            return new LoadContext(new NMS_1_21_R2(), () -> {
                CommandAPI.logWarning("Loading the CommandAPI with a potentially incompatible NMS implementation.");
                CommandAPI.logWarning("While you may find success with this, further updates might be necessary to fully support the version you are using.");
            });
        }
        throw new UnsupportedVersionException(version);
    }
}

