/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.chunk;

import com.fastasyncworldedit.core.util.NbtUtils;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.concurrency.LazyReference;
import com.sk89q.worldedit.util.nbt.BinaryTag;
import com.sk89q.worldedit.util.nbt.BinaryTagTypes;
import com.sk89q.worldedit.util.nbt.CompoundBinaryTag;
import com.sk89q.worldedit.util.nbt.IntBinaryTag;
import com.sk89q.worldedit.util.nbt.ListBinaryTag;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.chunk.Chunk;
import com.sk89q.worldedit.world.chunk.PackedIntArrayReader;
import com.sk89q.worldedit.world.entity.EntityTypes;
import com.sk89q.worldedit.world.storage.InvalidFormatException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class AnvilChunk17
implements Chunk {
    private final CompoundBinaryTag rootTag;
    private final Supplier<CompoundBinaryTag> entityTagSupplier;
    private BiomeType[] biomes;
    private BlockState[][] blocks;
    private Map<BlockVector3, CompoundBinaryTag> tileEntities;
    private List<BaseEntity> entities;
    private int minSectionPosition = 0;
    private int maxSectionPosition = 15;
    private int sectionCount = 16;

    @Deprecated
    public AnvilChunk17(CompoundTag tag, Supplier<CompoundTag> entitiesTag) throws DataException {
        this(tag.asBinaryTag(), () -> {
            CompoundTag compoundTag = (CompoundTag)entitiesTag.get();
            if (compoundTag == null) {
                return null;
            }
            return compoundTag.asBinaryTag();
        });
    }

    public AnvilChunk17(CompoundBinaryTag tag, Supplier<CompoundBinaryTag> entityTag) throws DataException {
        this.rootTag = tag;
        this.entityTagSupplier = entityTag;
        this.blocks = new BlockState[16][];
        ListBinaryTag sections = this.rootTag.getList("Sections");
        for (BinaryTag rawSectionTag : sections) {
            CompoundBinaryTag sectionTag;
            if (!(rawSectionTag instanceof CompoundBinaryTag) || (sectionTag = (CompoundBinaryTag)rawSectionTag).get("Y") == null || sectionTag.get("BlockStates") == null) continue;
            int y = NbtUtils.getInt(sectionTag, "Y");
            this.updateSectionIndexRange(y);
            ListBinaryTag paletteEntries = sectionTag.getList("Palette", BinaryTagTypes.COMPOUND);
            int paletteSize = paletteEntries.size();
            if (paletteSize == 0) continue;
            BlockState[] palette = new BlockState[paletteSize];
            for (int paletteEntryId = 0; paletteEntryId < paletteSize; ++paletteEntryId) {
                CompoundBinaryTag paletteEntry = (CompoundBinaryTag)paletteEntries.get(paletteEntryId);
                BlockType type = BlockTypes.get(paletteEntry.getString("Name"));
                if (type == null) {
                    throw new InvalidFormatException("Invalid block type: " + paletteEntry.getString("Name"));
                }
                BlockState blockState = type.getDefaultState();
                if (paletteEntry.get("Properties") != null) {
                    CompoundBinaryTag properties = (CompoundBinaryTag)NbtUtils.getChildTag(paletteEntry, "Properties", BinaryTagTypes.COMPOUND);
                    for (Property<?> property : blockState.getStates().keySet()) {
                        if (properties.get(property.getName()) == null) continue;
                        String value = properties.getString(property.getName());
                        try {
                            blockState = this.getBlockStateWith(blockState, property, value);
                        }
                        catch (IllegalArgumentException e) {
                            throw new InvalidFormatException("Invalid block state for " + blockState.getBlockType().getId() + ", " + property.getName() + ": " + value);
                        }
                    }
                }
                palette[paletteEntryId] = blockState;
            }
            long[] blockStatesSerialized = sectionTag.getLongArray("BlockStates");
            BlockState[] chunkSectionBlocks = new BlockState[4096];
            this.blocks[y - this.minSectionPosition] = chunkSectionBlocks;
            this.readBlockStates(palette, blockStatesSerialized, chunkSectionBlocks);
        }
    }

    private void updateSectionIndexRange(int layer) {
        if (layer >= this.minSectionPosition && layer <= this.maxSectionPosition) {
            return;
        }
        if (layer < this.minSectionPosition) {
            int diff = this.minSectionPosition - layer;
            this.sectionCount += diff;
            BlockState[][] tmpBlocks = new BlockState[this.sectionCount][];
            System.arraycopy(this.blocks, 0, tmpBlocks, diff, this.blocks.length);
            this.blocks = tmpBlocks;
            this.minSectionPosition = layer;
        } else {
            int diff = layer - this.maxSectionPosition;
            this.sectionCount += diff;
            BlockState[][] tmpBlocks = new BlockState[this.sectionCount][];
            System.arraycopy(this.blocks, 0, tmpBlocks, 0, this.blocks.length);
            this.blocks = tmpBlocks;
            this.maxSectionPosition = layer;
        }
    }

    protected void readBlockStates(BlockState[] palette, long[] blockStatesSerialized, BlockState[] chunkSectionBlocks) throws InvalidFormatException {
        PackedIntArrayReader reader = new PackedIntArrayReader(blockStatesSerialized);
        for (int blockPos = 0; blockPos < chunkSectionBlocks.length; ++blockPos) {
            int index = reader.get(blockPos);
            if (index >= palette.length) {
                throw new InvalidFormatException("Invalid block state table entry: " + index);
            }
            chunkSectionBlocks[blockPos] = palette[index];
        }
    }

    private <T> BlockState getBlockStateWith(BlockState source, Property<T> property, String value) {
        return source.with(property, (Object)property.getValueFor(value));
    }

    private void populateTileEntities() throws DataException {
        this.tileEntities = new HashMap<BlockVector3, CompoundBinaryTag>();
        if (this.rootTag.get("TileEntities") == null) {
            return;
        }
        ListBinaryTag tags = this.rootTag.getList("TileEntities");
        for (BinaryTag tag : tags) {
            if (!(tag instanceof CompoundBinaryTag)) {
                throw new InvalidFormatException("CompoundTag expected in TileEntities");
            }
            CompoundBinaryTag t = (CompoundBinaryTag)tag;
            int x = ((IntBinaryTag)t.get("x")).value();
            int y = ((IntBinaryTag)t.get("y")).value();
            int z = ((IntBinaryTag)t.get("z")).value();
            BlockVector3 vec = BlockVector3.at(x, y, z);
            this.tileEntities.put(vec, t);
        }
    }

    @Nullable
    private CompoundBinaryTag getBlockTileEntity(BlockVector3 position) throws DataException {
        if (this.tileEntities == null) {
            this.populateTileEntities();
        }
        return this.tileEntities.get(position);
    }

    @Override
    public BaseBlock getBlock(BlockVector3 position) throws DataException {
        int x = position.getX() & 0xF;
        int y = position.getY();
        int z = position.getZ() & 0xF;
        int section = y >> 4;
        int yIndex = y & 0xF;
        if (section < this.minSectionPosition || section > this.maxSectionPosition) {
            throw new DataException("Chunk does not contain position " + String.valueOf(position));
        }
        BlockState[] sectionBlocks = this.blocks[section - this.minSectionPosition];
        BlockState state = sectionBlocks != null ? sectionBlocks[yIndex << 8 | z << 4 | x] : BlockTypes.AIR.getDefaultState();
        CompoundBinaryTag tileEntity = this.getBlockTileEntity(position);
        if (tileEntity != null) {
            return state.toBaseBlock(tileEntity);
        }
        return state.toBaseBlock();
    }

    @Override
    public BiomeType getBiome(BlockVector3 position) throws DataException {
        if (this.biomes == null) {
            this.populateBiomes();
        }
        int x = (position.getX() & 0xF) >> 2;
        int y = position.getY() - (this.minSectionPosition << 4) >> 2;
        int z = (position.getZ() & 0xF) >> 2;
        return this.biomes[y << 4 | z << 2 | x];
    }

    private void populateBiomes() throws DataException {
        this.biomes = new BiomeType[64 * this.blocks.length];
        if (this.rootTag.get("Biomes") == null) {
            return;
        }
        int[] stored = this.rootTag.getIntArray("Biomes");
        for (int i = 0; i < 1024; ++i) {
            this.biomes[i] = BiomeTypes.getLegacy(stored[i]);
        }
    }

    @Override
    public List<BaseEntity> getEntities() throws DataException {
        if (this.entities == null) {
            this.populateEntities();
        }
        return this.entities;
    }

    private void populateEntities() throws DataException {
        CompoundBinaryTag entityTag;
        this.entities = new ArrayList<BaseEntity>();
        if (this.entityTagSupplier == null || (entityTag = this.entityTagSupplier.get()) == null) {
            return;
        }
        ListBinaryTag tags = entityTag.getList("Entities");
        for (BinaryTag tag : tags) {
            if (!(tag instanceof CompoundBinaryTag)) {
                throw new InvalidFormatException("CompoundTag expected in Entities");
            }
            CompoundBinaryTag t = (CompoundBinaryTag)tag;
            this.entities.add(new BaseEntity(EntityTypes.get(t.getString("id")), LazyReference.computed(t)));
        }
    }
}

