/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.block;

import com.fastasyncworldedit.core.registry.state.PropertyKey;
import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class FuzzyBlockState
extends BlockState {
    private final Map<PropertyKey, Object> props;
    private final Map<Property<?>, Object> values;

    FuzzyBlockState(BlockType blockType) {
        this(blockType.getDefaultState(), null);
    }

    public FuzzyBlockState(BlockState state) {
        this(state, null);
    }

    public FuzzyBlockState(BlockState state, Map<Property<?>, Object> values) {
        super(state.getBlockType(), state.getInternalId(), state.getOrdinal());
        if (values == null || values.isEmpty()) {
            this.props = Collections.emptyMap();
            this.values = Collections.emptyMap();
        } else {
            this.props = new HashMap<PropertyKey, Object>(values.size());
            for (Map.Entry<Property<?>, Object> entry : values.entrySet()) {
                this.props.put(entry.getKey().getKey(), entry.getValue());
            }
            this.values = new HashMap(values);
        }
    }

    public BlockState getFullState() {
        BlockStateHolder<BlockState> state = this.getBlockType().getDefaultState();
        for (Map.Entry<Property<?>, Object> entry : this.getStates().entrySet()) {
            Property<?> objKey = entry.getKey();
            state = state.with(objKey, entry.getValue());
        }
        return state;
    }

    @Override
    public BlockState toImmutableState() {
        return this.getFullState();
    }

    @Override
    public boolean equalsFuzzy(BlockStateHolder<?> o) {
        if (!this.getBlockType().equals(o.getBlockType())) {
            return false;
        }
        if (!this.props.isEmpty()) {
            for (Map.Entry<PropertyKey, Object> entry : this.props.entrySet()) {
                if (Objects.equals(o.getState(entry.getKey()), entry.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public BaseBlock toBaseBlock() {
        if (this.props == null || this.props.isEmpty()) {
            return super.toBaseBlock();
        }
        BlockStateHolder<BlockState> state = this;
        for (Map.Entry<PropertyKey, Object> entry : this.props.entrySet()) {
            state = state.with(entry.getKey(), entry.getValue());
        }
        return new BaseBlock((BlockState)state);
    }

    @Override
    public Map<Property<?>, Object> getStates() {
        return this.values;
    }

    @Override
    @Deprecated
    public CompoundTag getNbtData() {
        return this.getBlockType().getMaterial().isTile() ? this.getBlockType().getMaterial().getDefaultTile() : null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BlockType type;
        private final Map<Property<?>, Object> values = new HashMap();

        public Builder type(BlockType type) {
            Preconditions.checkNotNull((Object)type);
            this.type = type;
            return this;
        }

        public Builder type(BlockState state) {
            Preconditions.checkNotNull((Object)state);
            this.type = state.getBlockType();
            return this;
        }

        public <V> Builder withProperty(Property<V> property, V value) {
            Preconditions.checkNotNull(property);
            Preconditions.checkNotNull(value);
            Preconditions.checkNotNull((Object)this.type, (Object)"The type must be set before the properties!");
            Preconditions.checkNotNull(this.type.getProperty(property.getName()));
            this.values.put(property, value);
            return this;
        }

        public FuzzyBlockState build() {
            Preconditions.checkNotNull((Object)this.type);
            if (this.values.isEmpty()) {
                return this.type.getFuzzyMatcher();
            }
            return new FuzzyBlockState(this.type.getDefaultState(), this.values);
        }

        public Builder reset() {
            this.type = null;
            this.values.clear();
            return this;
        }
    }
}

