/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry.state;

import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.util.Direction;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

public class DirectionalProperty
extends AbstractProperty<Direction> {
    private final int[] map = new int[Direction.values().length];

    private DirectionalProperty(String name, List<Direction> values, int bitOffset) {
        super(name, values, bitOffset);
        Arrays.fill(this.map, -1);
        for (int i = 0; i < values.size(); ++i) {
            this.map[values.get((int)i).ordinal()] = i;
        }
    }

    @Override
    public DirectionalProperty withOffset(int bitOffset) {
        return new DirectionalProperty(this.getName(), this.getValues(), bitOffset);
    }

    @Override
    public int getIndex(Direction value) {
        return this.map[value.ordinal()];
    }

    @Override
    public int getIndexFor(CharSequence string) throws IllegalArgumentException {
        Direction dir = Direction.get(string);
        if (dir == null) {
            return -1;
        }
        return this.getIndex(dir);
    }

    public DirectionalProperty(String name, List<Direction> values) {
        this(name, values, 0);
    }

    @Override
    @Nullable
    public Direction getValueFor(String string) {
        Direction direction = Direction.valueOf(string.toUpperCase(Locale.ROOT));
        if (!this.getValues().contains((Object)direction)) {
            throw new IllegalArgumentException("Invalid direction value: " + string + ". Must be in " + this.getValues().toString());
        }
        return direction;
    }
}

