/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry.state;

import com.sk89q.worldedit.registry.state.AbstractProperty;
import java.util.List;
import javax.annotation.Nullable;

public class BooleanProperty
extends AbstractProperty<Boolean> {
    private final int defaultIndex;

    public BooleanProperty(String name, List<Boolean> values) {
        this(name, values, 0);
    }

    private BooleanProperty(String name, List<Boolean> values, int bitOffset) {
        super(name, values, bitOffset);
        this.defaultIndex = values.get(0).booleanValue() == Boolean.TRUE.booleanValue() ? 0 : 1;
    }

    @Override
    public int getIndex(Boolean value) {
        return value != false ? this.defaultIndex : 1 - this.defaultIndex;
    }

    @Override
    public BooleanProperty withOffset(int bitOffset) {
        return new BooleanProperty(this.getName(), this.getValues(), bitOffset);
    }

    @Override
    public int getIndexFor(CharSequence string) throws IllegalArgumentException {
        switch (string.charAt(0)) {
            case 't': {
                return this.defaultIndex;
            }
            case 'f': {
                return 1 - this.defaultIndex;
            }
        }
        return -1;
    }

    @Override
    @Nullable
    public Boolean getValueFor(String string) {
        boolean val = Boolean.parseBoolean(string);
        if (!this.getValues().contains(val)) {
            throw new IllegalArgumentException("Invalid boolean value: " + string + ". Must be in " + this.getValues().toString());
        }
        return val;
    }
}

