/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions;

import com.fastasyncworldedit.core.configuration.Settings;
import com.fastasyncworldedit.core.extent.filter.block.ChunkFilterBlock;
import com.fastasyncworldedit.core.math.BlockVectorSet;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.queue.Filter;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.AbstractRegion;
import com.sk89q.worldedit.regions.FlatRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.regions.RegionOperationException;
import com.sk89q.worldedit.world.World;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

public class CuboidRegion
extends AbstractRegion
implements FlatRegion {
    private int minX;
    private int minY;
    private int minZ;
    private int maxX;
    private int maxY;
    private int maxZ;
    private BlockVector3 pos1;
    private BlockVector3 pos2;

    public CuboidRegion(BlockVector3 pos1, BlockVector3 pos2) {
        this(null, pos1, pos2);
    }

    public CuboidRegion(World world, BlockVector3 pos1, BlockVector3 pos2) {
        super(world);
        Preconditions.checkNotNull((Object)pos1);
        Preconditions.checkNotNull((Object)pos2);
        this.pos1 = pos1;
        this.pos2 = pos2;
        this.recalculate();
    }

    public CuboidRegion(World world, BlockVector3 pos1, BlockVector3 pos2, boolean clampY) {
        super(world);
        Preconditions.checkNotNull((Object)pos1);
        Preconditions.checkNotNull((Object)pos2);
        this.pos1 = pos1;
        this.pos2 = pos2;
        if (clampY) {
            this.recalculate();
        } else {
            this.recalculateNoClamp();
        }
    }

    public BlockVector3 getPos1() {
        return this.pos1;
    }

    public void setPos1(BlockVector3 pos1) {
        this.pos1 = pos1;
        this.recalculate();
    }

    public BlockVector3 getPos2() {
        return this.pos2;
    }

    public void setPos2(BlockVector3 pos2) {
        this.pos2 = pos2;
        this.recalculate();
    }

    protected void recalculate() {
        if (this.pos1 == null || this.pos2 == null) {
            return;
        }
        this.pos1 = this.pos1.clampY(this.getWorldMinY(), this.getWorldMaxY());
        this.pos2 = this.pos2.clampY(this.getWorldMinY(), this.getWorldMaxY());
        this.minX = Math.min(this.pos1.getX(), this.pos2.getX());
        this.minY = Math.min(this.pos1.getY(), this.pos2.getY());
        this.minZ = Math.min(this.pos1.getZ(), this.pos2.getZ());
        this.maxX = Math.max(this.pos1.getX(), this.pos2.getX());
        this.maxY = Math.max(this.pos1.getY(), this.pos2.getY());
        this.maxZ = Math.max(this.pos1.getZ(), this.pos2.getZ());
    }

    protected void recalculateNoClamp() {
        if (this.pos1 == null || this.pos2 == null) {
            return;
        }
        this.minX = Math.min(this.pos1.getX(), this.pos2.getX());
        this.minY = Math.min(this.pos1.getY(), this.pos2.getY());
        this.minZ = Math.min(this.pos1.getZ(), this.pos2.getZ());
        this.maxX = Math.max(this.pos1.getX(), this.pos2.getX());
        this.maxY = Math.max(this.pos1.getY(), this.pos2.getY());
        this.maxZ = Math.max(this.pos1.getZ(), this.pos2.getZ());
    }

    public Region getFaces() {
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        return new RegionIntersection(new CuboidRegion(this.pos1.withX(min.getX()), this.pos2.withX(min.getX())), new CuboidRegion(this.pos1.withX(max.getX()), this.pos2.withX(max.getX())), new CuboidRegion(this.pos1.withZ(min.getZ()), this.pos2.withZ(min.getZ())), new CuboidRegion(this.pos1.withZ(max.getZ()), this.pos2.withZ(max.getZ())), new CuboidRegion(this.pos1.withY(min.getY()), this.pos2.withY(min.getY())), new CuboidRegion(this.pos1.withY(max.getY()), this.pos2.withY(max.getY())));
    }

    public Region getWalls() {
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        BlockVector3 dimensions = this.getDimensions();
        if (dimensions.getX() <= 2 || dimensions.getZ() <= 2) {
            return new RegionIntersection(this);
        }
        return new RegionIntersection(new CuboidRegion(this.pos1.withX(min.getX()), this.pos2.withX(min.getX())), new CuboidRegion(this.pos1.withX(max.getX()), this.pos2.withX(max.getX())), new CuboidRegion(this.pos1.withZ(min.getZ()).add(BlockVector3.UNIT_X), this.pos2.withZ(min.getZ()).subtract(BlockVector3.UNIT_X)), new CuboidRegion(this.pos1.withZ(max.getZ()).add(BlockVector3.UNIT_X), this.pos2.withZ(max.getZ()).subtract(BlockVector3.UNIT_X)));
    }

    @Override
    public BlockVector3 getMinimumPoint() {
        return this.pos1.getMinimum(this.pos2);
    }

    @Override
    public BlockVector3 getMaximumPoint() {
        return this.pos1.getMaximum(this.pos2);
    }

    @Override
    public CuboidRegion getBoundingBox() {
        return this;
    }

    @Override
    public int getMinimumY() {
        return this.minY;
    }

    @Override
    public int getMaximumY() {
        return this.maxY;
    }

    @Override
    public void expand(BlockVector3 ... changes) {
        Preconditions.checkNotNull((Object)changes);
        for (BlockVector3 change : changes) {
            if (change.getX() > 0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(change.getX(), 0, 0);
                } else {
                    this.pos2 = this.pos2.add(change.getX(), 0, 0);
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(change.getX(), 0, 0);
            } else {
                this.pos2 = this.pos2.add(change.getX(), 0, 0);
            }
            if (change.getY() > 0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(0, change.getY(), 0);
                } else {
                    this.pos2 = this.pos2.add(0, change.getY(), 0);
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(0, change.getY(), 0);
            } else {
                this.pos2 = this.pos2.add(0, change.getY(), 0);
            }
            if (change.getZ() > 0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(0, 0, change.getZ());
                    continue;
                }
                this.pos2 = this.pos2.add(0, 0, change.getZ());
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(0, 0, change.getZ());
                continue;
            }
            this.pos2 = this.pos2.add(0, 0, change.getZ());
        }
        this.recalculate();
    }

    @Override
    public void contract(BlockVector3 ... changes) {
        Preconditions.checkNotNull((Object)changes);
        for (BlockVector3 change : changes) {
            if (change.getX() < 0) {
                if (Math.max(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                    this.pos1 = this.pos1.add(change.getX(), 0, 0);
                } else {
                    this.pos2 = this.pos2.add(change.getX(), 0, 0);
                }
            } else if (Math.min(this.pos1.getX(), this.pos2.getX()) == this.pos1.getX()) {
                this.pos1 = this.pos1.add(change.getX(), 0, 0);
            } else {
                this.pos2 = this.pos2.add(change.getX(), 0, 0);
            }
            if (change.getY() < 0) {
                if (Math.max(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                    this.pos1 = this.pos1.add(0, change.getY(), 0);
                } else {
                    this.pos2 = this.pos2.add(0, change.getY(), 0);
                }
            } else if (Math.min(this.pos1.getY(), this.pos2.getY()) == this.pos1.getY()) {
                this.pos1 = this.pos1.add(0, change.getY(), 0);
            } else {
                this.pos2 = this.pos2.add(0, change.getY(), 0);
            }
            if (change.getZ() < 0) {
                if (Math.max(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                    this.pos1 = this.pos1.add(0, 0, change.getZ());
                    continue;
                }
                this.pos2 = this.pos2.add(0, 0, change.getZ());
                continue;
            }
            if (Math.min(this.pos1.getZ(), this.pos2.getZ()) == this.pos1.getZ()) {
                this.pos1 = this.pos1.add(0, 0, change.getZ());
                continue;
            }
            this.pos2 = this.pos2.add(0, 0, change.getZ());
        }
        this.recalculate();
    }

    @Override
    public void shift(BlockVector3 change) throws RegionOperationException {
        this.pos1 = this.pos1.add(change);
        this.pos2 = this.pos2.add(change);
        this.recalculate();
    }

    @Override
    public Set<BlockVector2> getChunks() {
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        final int maxX = max.getBlockX() >> 4;
        final int minX = min.getBlockX() >> 4;
        final int maxZ = max.getBlockZ() >> 4;
        final int minZ = min.getBlockZ() >> 4;
        final int size = (maxX - minX + 1) * (maxZ - minZ + 1);
        return new AbstractSet<BlockVector2>(){

            @Override
            @Nonnull
            public Iterator<BlockVector2> iterator() {
                return new Iterator<BlockVector2>(){
                    final int bx;
                    final int bz;
                    final int tx;
                    final int tz;
                    private int x;
                    private int z;
                    int regionX;
                    int regionZ;
                    int rbx;
                    int rbz;
                    int rtx;
                    int rtz;
                    boolean hasNext;
                    {
                        this.bx = minX;
                        this.bz = minZ;
                        this.tx = maxX;
                        this.tz = maxZ;
                        this.x = minX;
                        this.z = minZ;
                        this.regionX = this.x >> 5;
                        this.regionZ = this.z >> 5;
                        this.rbx = Math.max(this.bx, this.regionX << 5);
                        this.rbz = Math.max(this.bz, this.regionZ << 5);
                        this.rtx = Math.min(this.tx, 31 + (this.regionX << 5));
                        this.rtz = Math.min(this.tz, 31 + (this.regionZ << 5));
                        this.hasNext = true;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.hasNext;
                    }

                    @Override
                    public BlockVector2 next() {
                        int curX = this.x++;
                        int curZ = this.z++;
                        if (this.x > this.rtx) {
                            if (this.z > this.rtz) {
                                if (this.x > this.tx) {
                                    this.x = this.bx;
                                    if (this.z > this.tz) {
                                        if (!this.hasNext) {
                                            throw new NoSuchElementException("End of iterator"){

                                                @Override
                                                public Throwable fillInStackTrace() {
                                                    return this;
                                                }
                                            };
                                        }
                                        this.x = this.tx;
                                        this.hasNext = false;
                                        return BlockVector2.at(curX, curZ);
                                    }
                                } else {
                                    this.z = this.rbz;
                                }
                                this.regionX = this.x >> 5;
                                this.regionZ = this.z >> 5;
                                this.rbx = Math.max(this.bx, this.regionX << 5);
                                this.rbz = Math.max(this.bz, this.regionZ << 5);
                                this.rtx = Math.min(this.tx, 31 + (this.regionX << 5));
                                this.rtz = Math.min(this.tz, 31 + (this.regionZ << 5));
                            } else {
                                this.x = this.rbx;
                            }
                        }
                        return BlockVector2.at(curX, curZ);
                    }
                };
            }

            @Override
            public int size() {
                return size;
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof BlockVector2) {
                    BlockVector2 cv = (BlockVector2)o;
                    return cv.getX() >= minX && cv.getX() <= maxX && cv.getZ() >= minZ && cv.getZ() <= maxZ;
                }
                return false;
            }
        };
    }

    @Override
    public Set<BlockVector3> getChunkCubes() {
        BlockVectorSet chunks = new BlockVectorSet();
        BlockVector3 min = this.getMinimumPoint();
        BlockVector3 max = this.getMaximumPoint();
        for (int x = min.getBlockX() >> 4; x <= max.getBlockX() >> 4; ++x) {
            for (int z = min.getBlockZ() >> 4; z <= max.getBlockZ() >> 4; ++z) {
                for (int y = min.getBlockY() >> 4; y <= max.getBlockY() >> 4; ++y) {
                    chunks.add(BlockVector3.at(x, y, z));
                }
            }
        }
        return chunks;
    }

    @Override
    public boolean contains(BlockVector3 position) {
        return this.contains(position.getX(), position.getY(), position.getZ());
    }

    @Override
    public boolean contains(int x, int y, int z) {
        return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ && y >= this.minY && y <= this.maxY;
    }

    @Override
    public boolean contains(int x, int z) {
        return x >= this.minX && x <= this.maxX && z >= this.minZ && z <= this.maxZ;
    }

    @Override
    public Iterator<BlockVector3> iterator() {
        if (Settings.settings().HISTORY.COMPRESSION_LEVEL >= 9) {
            return this.iterator_old();
        }
        return new Iterator<BlockVector3>(){
            final MutableBlockVector3 mutable = new MutableBlockVector3(0, 0, 0);
            private final BlockVector3 min = CuboidRegion.this.getMinimumPoint();
            private final BlockVector3 max = CuboidRegion.this.getMaximumPoint();
            final int bx = this.min.getBlockX();
            final int by = this.min.getBlockY();
            final int bz = this.min.getBlockZ();
            final int tx = this.max.getBlockX();
            final int ty = this.max.getBlockY();
            final int tz = this.max.getBlockZ();
            private int x = this.min.getBlockX();
            private int y = this.min.getBlockY();
            private int z = this.min.getBlockZ();
            int cx = this.x >> 4;
            int cz = this.z >> 4;
            int cbx = Math.max(this.bx, this.cx << 4);
            int cbz = Math.max(this.bz, this.cz << 4);
            int ctx = Math.min(this.tx, 15 + (this.cx << 4));
            int ctz = Math.min(this.tz, 15 + (this.cz << 4));
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public BlockVector3 next() {
                this.mutable.mutX(this.x);
                this.mutable.mutY(this.y);
                this.mutable.mutZ(this.z);
                if (++this.x > this.ctx) {
                    if (++this.z > this.ctz) {
                        if (++this.y > this.ty) {
                            this.y = this.by;
                            if (this.x > this.tx) {
                                this.x = this.bx;
                                if (this.z > this.tz) {
                                    if (!this.hasNext) {
                                        throw new NoSuchElementException("End of iterator"){

                                            @Override
                                            public Throwable fillInStackTrace() {
                                                return this;
                                            }
                                        };
                                    }
                                    this.x = this.tx;
                                    this.y = this.ty;
                                    this.hasNext = false;
                                    return this.mutable;
                                }
                            } else {
                                this.z = this.cbz;
                            }
                            this.cx = this.x >> 4;
                            this.cz = this.z >> 4;
                            this.cbx = Math.max(this.bx, this.cx << 4);
                            this.cbz = Math.max(this.bz, this.cz << 4);
                            this.ctx = Math.min(this.tx, 15 + (this.cx << 4));
                            this.ctz = Math.min(this.tz, 15 + (this.cz << 4));
                        } else {
                            this.x = this.cbx;
                            this.z = this.cbz;
                        }
                    } else {
                        this.x = this.cbx;
                    }
                }
                return this.mutable;
            }
        };
    }

    public Iterator<BlockVector3> iterator_old() {
        final MutableBlockVector3 mutable = new MutableBlockVector3(0, 0, 0);
        return new Iterator<BlockVector3>(){
            private final BlockVector3 min;
            private final BlockVector3 max;
            private int nextX;
            private int nextY;
            private int nextZ;
            private boolean hasNext;
            {
                this.min = CuboidRegion.this.getMinimumPoint();
                this.max = CuboidRegion.this.getMaximumPoint();
                this.nextX = this.min.getBlockX();
                this.nextY = this.min.getBlockY();
                this.nextZ = this.min.getBlockZ();
                this.hasNext = true;
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public BlockVector3 next() {
                mutable.mutX(this.nextX);
                mutable.mutY(this.nextY);
                mutable.mutZ(this.nextZ);
                if (++this.nextX > this.max.getBlockX()) {
                    this.nextX = this.min.getBlockX();
                    if (++this.nextZ > this.max.getBlockZ()) {
                        this.nextZ = this.min.getBlockZ();
                        if (++this.nextY > this.max.getBlockY()) {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            this.nextX = this.max.getBlockX();
                            this.nextZ = this.max.getBlockZ();
                            this.nextY = this.max.getBlockY();
                            this.hasNext = false;
                        }
                    }
                }
                return mutable;
            }
        };
    }

    @Override
    public Iterable<BlockVector2> asFlatRegion() {
        return () -> new Iterator<BlockVector2>(){
            private final BlockVector3 min;
            private final BlockVector3 max;
            private int nextX;
            private int nextZ;
            {
                this.min = CuboidRegion.this.getMinimumPoint();
                this.max = CuboidRegion.this.getMaximumPoint();
                this.nextX = this.min.getBlockX();
                this.nextZ = this.min.getBlockZ();
            }

            @Override
            public boolean hasNext() {
                return this.nextZ != Integer.MAX_VALUE;
            }

            @Override
            public BlockVector2 next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BlockVector2 answer = BlockVector2.at(this.nextX, this.nextZ);
                if (++this.nextX > this.max.getBlockX()) {
                    this.nextX = this.min.getBlockX();
                    if (++this.nextZ > this.max.getBlockZ()) {
                        this.nextZ = Integer.MAX_VALUE;
                        this.nextX = Integer.MAX_VALUE;
                    }
                }
                return answer;
            }
        };
    }

    @Override
    public String toString() {
        return String.valueOf(this.getMinimumPoint()) + " - " + String.valueOf(this.getMaximumPoint());
    }

    @Override
    public CuboidRegion clone() {
        return (CuboidRegion)super.clone();
    }

    public static CuboidRegion makeCuboid(Region region) {
        Preconditions.checkNotNull((Object)region);
        return new CuboidRegion(region.getMinimumPoint(), region.getMaximumPoint());
    }

    public static boolean contains(CuboidRegion region) {
        BlockVector3 min = region.getMinimumPoint();
        BlockVector3 max = region.getMaximumPoint();
        return region.contains(min.getBlockX(), min.getBlockY(), min.getBlockZ()) && region.contains(max.getBlockX(), max.getBlockY(), max.getBlockZ());
    }

    public static CuboidRegion fromCenter(BlockVector3 origin, int apothem) {
        Preconditions.checkNotNull((Object)origin);
        Preconditions.checkArgument((apothem >= 0 ? 1 : 0) != 0, (Object)"apothem => 0 required");
        BlockVector3 size = BlockVector3.ONE.multiply(apothem);
        return new CuboidRegion(origin.subtract(size), origin.add(size));
    }

    public int getMinimumX() {
        return this.minX;
    }

    public int getMinimumZ() {
        return this.minZ;
    }

    public int getMaximumX() {
        return this.maxX;
    }

    public int getMaximumZ() {
        return this.maxZ;
    }

    @Override
    public void filter(IChunk chunk, Filter filter, ChunkFilterBlock block, IChunkGet get, IChunkSet set, boolean full) {
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        block = block.initChunk(chunkX, chunkZ);
        if (this.minX + 15 >> 4 <= chunkX && this.maxX - 15 >> 4 >= chunkX && this.minZ + 15 >> 4 <= chunkZ && this.maxZ - 15 >> 4 >= chunkZ) {
            this.filter(chunk, filter, block, get, set, this.minY, this.maxY, full);
            return;
        }
        int localMinX = Math.max(this.minX, chunkX << 4) & 0xF;
        int localMaxX = Math.min(this.maxX, 15 + (chunkX << 4)) & 0xF;
        int localMinZ = Math.max(this.minZ, chunkZ << 4) & 0xF;
        int localMaxZ = Math.min(this.maxZ, 15 + (chunkZ << 4)) & 0xF;
        int yStart = this.minY & 0xF;
        int yEnd = this.maxY & 0xF;
        int minSection = this.minY >> 4;
        int maxSection = this.maxY >> 4;
        if (minSection == maxSection) {
            this.filter(chunk, filter, block, get, set, minSection, localMinX, yStart, localMinZ, localMaxX, yEnd, localMaxZ, full);
            return;
        }
        if (yStart != 0) {
            this.filter(chunk, filter, block, get, set, minSection, localMinX, yStart, localMinZ, localMaxX, 15, localMaxZ, full);
            ++minSection;
        }
        if (yEnd != 15) {
            this.filter(chunk, filter, block, get, set, maxSection, localMinX, 0, localMinZ, localMaxX, yEnd, localMaxZ, full);
            --maxSection;
        }
        for (int layer = minSection; layer <= maxSection; ++layer) {
            this.filter(chunk, filter, block, get, set, layer, localMinX, 0, localMinZ, localMaxX, 15, localMaxZ, full);
        }
    }

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        int bx = chunk.getX() << 4;
        int bz = chunk.getZ() << 4;
        int tx = bx + 15;
        int tz = bz + 15;
        if (bx >= this.minX && tx <= this.maxX && bz >= this.minZ && tz <= this.maxZ) {
            if (this.minY <= set.getMinSectionPosition() << 4 && this.maxY >= (set.getMaxSectionPosition() << 4) + 15) {
                return set;
            }
            this.trimY(set, this.minY, this.maxY, true);
            BlockVector3 chunkPos = chunk.getChunkBlockCoord().withY(0);
            this.trimNBT(set, this::contains, pos -> this.contains(pos.add(chunkPos)));
            return set;
        }
        if (tx >= this.minX && bx <= this.maxX && tz >= this.minZ && bz <= this.maxZ) {
            boolean trimZ;
            if (this.minY > set.getMinSectionPosition() << 4 || this.maxY < (set.getMaxSectionPosition() << 4) + 15) {
                this.trimY(set, this.minY, this.maxY, true);
            }
            int lowerX = Math.max(0, this.minX - bx);
            int upperX = Math.min(15, 15 + this.maxX - tx);
            int lowerZ = Math.max(0, this.minZ - bz);
            int upperZ = Math.min(15, 15 + this.maxZ - tz);
            int upperZi = upperZ + 1 << 4;
            int lowerZi = lowerZ << 4;
            boolean trimX = lowerX != 0 || upperX != 15;
            boolean bl = trimZ = lowerZ != 0 || upperZ != 15;
            if (!trimX && !trimZ) {
                return set;
            }
            for (int layer = get.getMinSectionPosition(); layer < get.getMaxSectionPosition(); ++layer) {
                if (!set.hasSection(layer)) continue;
                char[] arr = Objects.requireNonNull(set.loadIfPresent(layer));
                int indexY = 0;
                int y = 0;
                while (y < 16) {
                    int x;
                    int z;
                    int index;
                    if (trimZ) {
                        index = indexY;
                        for (z = 0; z < lowerZ; ++z) {
                            x = 0;
                            while (x < 16) {
                                arr[index] = '\u0000';
                                ++x;
                                ++index;
                            }
                        }
                        index = indexY + upperZi;
                        for (z = upperZ + 1; z < 16; ++z) {
                            x = 0;
                            while (x < 16) {
                                arr[index] = '\u0000';
                                ++x;
                                ++index;
                            }
                        }
                    }
                    if (trimX) {
                        index = indexY + lowerZi;
                        z = lowerZ;
                        while (z <= upperZ) {
                            for (x = 0; x < lowerX; ++x) {
                                arr[index + x] = '\u0000';
                            }
                            for (x = upperX + 1; x < 16; ++x) {
                                arr[index + x] = '\u0000';
                            }
                            ++z;
                            index += 16;
                        }
                    }
                    ++y;
                    indexY += 256;
                }
                set.setBlocks(layer, arr);
            }
            BlockVector3 chunkPos = BlockVector3.at(chunk.getX() << 4, 0, chunk.getZ() << 4);
            this.trimNBT(set, this::contains, pos -> this.contains(pos.add(chunkPos)));
            return set;
        }
        return null;
    }

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set, boolean asBlacklist) {
        if (!asBlacklist) {
            return this.processSet(chunk, get, set);
        }
        int bx = chunk.getX() << 4;
        int bz = chunk.getZ() << 4;
        int tx = bx + 15;
        int tz = bz + 15;
        if (bx >= this.minX && tx <= this.maxX && bz >= this.minZ && tz <= this.maxZ) {
            int sMaxY = (set.getMaxSectionPosition() << 4) + 15;
            int sMinY = set.getMinSectionPosition() << 4;
            if (this.minY <= sMinY && this.maxY >= sMaxY) {
                return null;
            }
            this.trimY(set, this.minY, this.maxY, false);
            BlockVector3 chunkPos = chunk.getChunkBlockCoord().withY(0);
            this.trimNBT(set, this::contains, pos -> this.contains(pos.add(chunkPos)));
            return set;
        }
        if (tx >= this.minX && bx <= this.maxX && tz >= this.minZ && bz <= this.maxZ) {
            if (this.minY > set.getMinSectionPosition() << 4 || this.maxY < (set.getMaxSectionPosition() << 4) + 15) {
                this.trimY(set, this.minY, this.maxY, false);
            }
            int lowerX = Math.max(0, this.minX - bx);
            int upperX = Math.min(15, 15 + this.maxX - tx);
            int lowerZ = Math.max(0, this.minZ - bz);
            int upperZ = Math.min(15, 15 + this.maxZ - tz);
            int lowerZi = lowerZ << 4;
            boolean trimX = lowerX != 0 || upperX != 15;
            boolean trimZ = lowerZ != 0 || upperZ != 15;
            for (int layer = get.getMinSectionPosition(); layer < get.getMaxSectionPosition(); ++layer) {
                if (!set.hasSection(layer)) continue;
                char[] arr = Objects.requireNonNull(set.loadIfPresent(layer));
                if (!trimX && !trimZ) continue;
                int indexY = 0;
                int y = 0;
                while (y < 16) {
                    int x;
                    int z;
                    int index;
                    if (trimZ) {
                        index = indexY;
                        for (z = lowerZ; z <= upperZ; ++z) {
                            x = 0;
                            while (x < 16) {
                                arr[index] = '\u0000';
                                ++x;
                                ++index;
                            }
                        }
                    }
                    if (trimX) {
                        index = indexY + lowerZi;
                        z = lowerZ;
                        while (z <= upperZ) {
                            for (x = lowerX; x <= upperX; ++x) {
                                arr[index + x] = '\u0000';
                            }
                            ++z;
                            index += 16;
                        }
                    }
                    ++y;
                    indexY += 256;
                }
                set.setBlocks(layer, arr);
            }
            BlockVector3 chunkPos = chunk.getChunkBlockCoord().withY(0);
            this.trimNBT(set, bv3 -> !this.contains((BlockVector3)bv3), bv3 -> !this.contains(bv3.add(chunkPos)));
            return set;
        }
        return set;
    }
}

