/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.math.convolution;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.convolution.HeightMapFilter;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import javax.annotation.Nullable;

public class SnowHeightMap {
    private static final Property<Integer> LAYERS = BlockTypes.SNOW.getProperty("layers");
    private final float[] data;
    private final int width;
    private final int height;
    private final Region region;
    private final EditSession session;

    public SnowHeightMap(EditSession session, Region region, @Nullable Mask mask) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)region);
        this.session = session;
        this.region = region;
        this.width = region.getWidth();
        this.height = region.getLength();
        int minX = region.getMinimumPoint().getBlockX();
        int minY = region.getMinimumPoint().getBlockY();
        int minZ = region.getMinimumPoint().getBlockZ();
        int maxY = region.getMaximumPoint().getBlockY();
        this.data = new float[this.width * this.height];
        for (int z = 0; z < this.height; ++z) {
            for (int x = 0; x < this.width; ++x) {
                int highestBlockY = mask != null ? session.getHighestTerrainBlock(x + minX, z + minZ, minY, maxY, mask) : session.getHighestTerrainBlock(x + minX, z + minZ, minY, maxY);
                BlockState upper = session.getBlock(x + minX, highestBlockY + 1, z + minZ);
                if (upper.getBlockType() == BlockTypes.SNOW) {
                    Integer amountLayers = upper.getState(LAYERS);
                    this.data[z * this.width + x] = (float)(highestBlockY + 1) + ((float)amountLayers.intValue() - 1.0f) / 8.0f;
                    continue;
                }
                BlockState block = session.getBlock(x + minX, highestBlockY, z + minZ);
                this.data[z * this.width + x] = block.getBlockType().getMaterial().isAir() ? (float)highestBlockY : (float)(highestBlockY + 1);
            }
        }
    }

    public float[] applyFilter(HeightMapFilter filter, int iterations) {
        Preconditions.checkNotNull((Object)filter);
        float[] newData = new float[this.data.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        for (int i = 0; i < iterations; ++i) {
            newData = filter.filter(newData, this.width, this.height, 0.0625f);
        }
        return newData;
    }

    public int applyChanges(float[] data, int layerBlocks) throws MaxChangedBlocksException {
        Preconditions.checkNotNull((Object)data);
        BlockVector3 minY = this.region.getMinimumPoint();
        int originX = minY.getBlockX();
        int originY = minY.getBlockY();
        int originZ = minY.getBlockZ();
        int maxY = this.region.getMaximumPoint().getBlockY();
        BlockState fillerAir = BlockTypes.AIR.getDefaultState();
        BlockState fillerSnow = BlockTypes.SNOW_BLOCK.getDefaultState();
        int blocksChanged = 0;
        for (int z = 0; z < this.height; ++z) {
            for (int x = 0; x < this.width; ++x) {
                int y;
                int index = z * this.width + x;
                float curHeight = this.data[index];
                if (curHeight == (float)originY) continue;
                float newHeight = Math.min((float)maxY, data[index]);
                int xr = x + originX;
                int zr = z + originZ;
                double scale = (double)(curHeight - (float)originY) / (double)(newHeight - (float)originY);
                if (newHeight >= curHeight) {
                    BlockState existing = this.session.getBlock(xr, (int)Math.floor(curHeight), zr);
                    if (existing.getBlockType().getMaterial().isLiquid()) continue;
                    this.setSnowLayer(xr, zr, newHeight);
                    ++blocksChanged;
                    for (int y2 = (int)Math.floor(newHeight - 1.0f - (float)originY); y2 >= 0; --y2) {
                        if ((double)y2 >= Math.floor(newHeight - 1.0f - (float)originY - (float)layerBlocks)) {
                            this.session.setBlock(xr, originY + y2, zr, fillerSnow);
                        } else {
                            int copyFrom = (int)Math.floor((double)y2 * scale);
                            BlockState block = this.session.getBlock(xr, originY + copyFrom, zr);
                            this.session.setBlock(xr, originY + y2, zr, block);
                        }
                        ++blocksChanged;
                    }
                    continue;
                }
                for (y = 0; y < (int)Math.floor(newHeight - (float)originY); ++y) {
                    if (y >= (int)Math.floor(newHeight - (float)originY - (float)layerBlocks)) {
                        this.session.setBlock(xr, originY + y, zr, fillerSnow);
                    } else {
                        int copyFrom = (int)Math.floor((double)y * scale);
                        BlockState block = this.session.getBlock(xr, originY + copyFrom, zr);
                        this.session.setBlock(xr, originY + y, zr, block);
                    }
                    ++blocksChanged;
                }
                this.setSnowLayer(xr, zr, newHeight);
                ++blocksChanged;
                y = (int)Math.floor(newHeight + 1.0f);
                while ((double)y <= Math.floor(curHeight)) {
                    this.session.setBlock(xr, y, zr, fillerAir);
                    ++blocksChanged;
                    ++y;
                }
            }
        }
        return blocksChanged;
    }

    private void setSnowLayer(int x, int z, float newHeight) throws MaxChangedBlocksException {
        int y = (int)Math.floor(newHeight);
        int numOfLayers = (int)((newHeight - (float)y) * 8.0f) + 1;
        this.session.setBlock(x, y, z, BlockTypes.SNOW.getDefaultState().with(LAYERS, (Object)numOfLayers));
    }
}

