/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.math;

import com.fastasyncworldedit.core.math.MutableVector3;
import com.fastasyncworldedit.core.math.Vector3Impl;
import com.fastasyncworldedit.core.util.MathMan;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.MathUtils;
import com.sk89q.worldedit.math.Vector2;
import java.util.Comparator;

public abstract class Vector3 {
    public static final Vector3 ZERO = Vector3.at(0.0, 0.0, 0.0);
    public static final Vector3 UNIT_X = Vector3.at(1.0, 0.0, 0.0);
    public static final Vector3 UNIT_Y = Vector3.at(0.0, 1.0, 0.0);
    public static final Vector3 UNIT_Z = Vector3.at(0.0, 0.0, 1.0);
    public static final Vector3 ONE = Vector3.at(1.0, 1.0, 1.0);

    public static Vector3 at(double x, double y, double z) {
        return new Vector3Impl(x, y, z);
    }

    public static Comparator<Vector3> sortByCoordsYzx() {
        return YzxOrderComparator.YZX_ORDER;
    }

    public int getBlockX() {
        return MathMan.roundInt(this.getX());
    }

    public int getBlockY() {
        return MathMan.roundInt(this.getY());
    }

    public int getBlockZ() {
        return MathMan.roundInt(this.getZ());
    }

    public MutableVector3 setComponents(Vector3 other) {
        return new MutableVector3(other);
    }

    public MutableVector3 setComponents(int x, int y, int z) {
        return new MutableVector3(x, y, z);
    }

    public MutableVector3 setComponents(double x, double y, double z) {
        return new MutableVector3(x, y, z);
    }

    public MutableVector3 mutX(int x) {
        return new MutableVector3((double)x, this.getY(), this.getZ());
    }

    public MutableVector3 mutX(double x) {
        return new MutableVector3(x, this.getY(), this.getZ());
    }

    public MutableVector3 mutY(int y) {
        return new MutableVector3(this.getX(), (double)y, this.getZ());
    }

    public MutableVector3 mutY(double y) {
        return new MutableVector3(this.getX(), y, this.getZ());
    }

    public MutableVector3 mutZ(int z) {
        return new MutableVector3(this.getX(), this.getY(), (double)z);
    }

    public MutableVector3 mutZ(double z) {
        return new MutableVector3(this.getX(), this.getY(), z);
    }

    public abstract double getX();

    public Vector3 withX(double x) {
        return Vector3.at(x, this.getY(), this.getZ());
    }

    public abstract double getY();

    public Vector3 withY(double y) {
        return Vector3.at(this.getX(), y, this.getZ());
    }

    public abstract double getZ();

    public Vector3 withZ(double z) {
        return Vector3.at(this.getX(), this.getY(), z);
    }

    public Vector3 add(Vector3 other) {
        return this.add(other.getX(), other.getY(), other.getZ());
    }

    public Vector3 add(double x, double y, double z) {
        return Vector3.at(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public Vector3 add(Vector3 ... others) {
        double newX = this.getX();
        double newY = this.getY();
        double newZ = this.getZ();
        for (Vector3 other : others) {
            newX += other.getX();
            newY += other.getY();
            newZ += other.getZ();
        }
        return Vector3.at(newX, newY, newZ);
    }

    public Vector3 subtract(Vector3 other) {
        return this.subtract(other.getX(), other.getY(), other.getZ());
    }

    public Vector3 subtract(double x, double y, double z) {
        return Vector3.at(this.getX() - x, this.getY() - y, this.getZ() - z);
    }

    public Vector3 subtract(Vector3 ... others) {
        double newX = this.getX();
        double newY = this.getY();
        double newZ = this.getZ();
        for (Vector3 other : others) {
            newX -= other.getX();
            newY -= other.getY();
            newZ -= other.getZ();
        }
        return Vector3.at(newX, newY, newZ);
    }

    public Vector3 multiply(Vector3 other) {
        return this.multiply(other.getX(), other.getY(), other.getZ());
    }

    public Vector3 multiply(double x, double y, double z) {
        return Vector3.at(this.getX() * x, this.getY() * y, this.getZ() * z);
    }

    public Vector3 multiply(Vector3 ... others) {
        double newX = this.getX();
        double newY = this.getY();
        double newZ = this.getZ();
        for (Vector3 other : others) {
            newX *= other.getX();
            newY *= other.getY();
            newZ *= other.getZ();
        }
        return Vector3.at(newX, newY, newZ);
    }

    public Vector3 multiply(double n) {
        return this.multiply(n, n, n);
    }

    public Vector3 divide(Vector3 other) {
        return this.divide(other.getX(), other.getY(), other.getZ());
    }

    public Vector3 divide(double x, double y, double z) {
        return Vector3.at(this.getX() / x, this.getY() / y, this.getZ() / z);
    }

    public Vector3 divide(double n) {
        return this.divide(n, n, n);
    }

    public double length() {
        return Math.sqrt(this.lengthSq());
    }

    public double lengthSq() {
        return this.getX() * this.getX() + this.getY() * this.getY() + this.getZ() * this.getZ();
    }

    public double distance(Vector3 other) {
        return Math.sqrt(this.distanceSq(other));
    }

    public double distanceSq(Vector3 other) {
        double dx = other.getX() - this.getX();
        double dy = other.getY() - this.getY();
        double dz = other.getZ() - this.getZ();
        return dx * dx + dy * dy + dz * dz;
    }

    public Vector3 normalize() {
        return this.divide(this.length());
    }

    public double dot(Vector3 other) {
        return this.getX() * other.getX() + this.getY() * other.getY() + this.getZ() * other.getZ();
    }

    public Vector3 cross(Vector3 other) {
        return Vector3.at(this.getY() * other.getZ() - this.getZ() * other.getY(), this.getZ() * other.getX() - this.getX() * other.getZ(), this.getX() * other.getY() - this.getY() * other.getX());
    }

    public boolean containedWithin(Vector3 min, Vector3 max) {
        return this.getX() >= min.getX() && this.getX() <= max.getX() && this.getY() >= min.getY() && this.getY() <= max.getY() && this.getZ() >= min.getZ() && this.getZ() <= max.getZ();
    }

    public Vector3 clampY(int min, int max) {
        Preconditions.checkArgument((min <= max ? 1 : 0) != 0, (Object)"minimum cannot be greater than maximum");
        if (this.getY() < (double)min) {
            return Vector3.at(this.getX(), min, this.getZ());
        }
        if (this.getY() > (double)max) {
            return Vector3.at(this.getX(), max, this.getZ());
        }
        return this;
    }

    public Vector3 floor() {
        return Vector3.at(Math.floor(this.getX()), Math.floor(this.getY()), Math.floor(this.getZ()));
    }

    public Vector3 ceil() {
        return Vector3.at(Math.ceil(this.getX()), Math.ceil(this.getY()), Math.ceil(this.getZ()));
    }

    public Vector3 round() {
        return Vector3.at(Math.floor(this.getX() + 0.5), Math.floor(this.getY() + 0.5), Math.floor(this.getZ() + 0.5));
    }

    public Vector3 roundHalfUp() {
        return Vector3.at(MathUtils.roundHalfUp(this.getX()), MathUtils.roundHalfUp(this.getY()), MathUtils.roundHalfUp(this.getZ()));
    }

    public Vector3 abs() {
        return Vector3.at(Math.abs(this.getX()), Math.abs(this.getY()), Math.abs(this.getZ()));
    }

    public Vector3 transform2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x = this.getX() - aboutX;
        double z = this.getZ() - aboutZ;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x2 = x * cos - z * sin;
        double z2 = x * sin + z * cos;
        return Vector3.at(x2 + aboutX + translateX, this.getY(), z2 + aboutZ + translateZ);
    }

    public double toPitch() {
        double x = this.getX();
        double z = this.getZ();
        if (x == 0.0 && z == 0.0) {
            return this.getY() > 0.0 ? -90.0 : 90.0;
        }
        double x2 = x * x;
        double z2 = z * z;
        double xz = Math.sqrt(x2 + z2);
        return Math.toDegrees(Math.atan(-this.getY() / xz));
    }

    public double toYaw() {
        double x = this.getX();
        double z = this.getZ();
        double t = Math.atan2(-x, z);
        double tau = Math.PI * 2;
        return Math.toDegrees((t + tau) % tau);
    }

    public Vector3 getMinimum(Vector3 v2) {
        return Vector3.at(Math.min(this.getX(), v2.getX()), Math.min(this.getY(), v2.getY()), Math.min(this.getZ(), v2.getZ()));
    }

    public Vector3 getMaximum(Vector3 v2) {
        return Vector3.at(Math.max(this.getX(), v2.getX()), Math.max(this.getY(), v2.getY()), Math.max(this.getZ(), v2.getZ()));
    }

    public static BlockVector3 toBlockPoint(double x, double y, double z) {
        return BlockVector3.at(x, y, z);
    }

    public BlockVector3 toBlockPoint() {
        return Vector3.toBlockPoint(this.getX(), this.getY(), this.getZ());
    }

    public Vector2 toVector2() {
        return Vector2.at(this.getX(), this.getZ());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector3)) {
            return false;
        }
        Vector3 other = (Vector3)obj;
        return other.getX() == this.getX() && other.getY() == this.getY() && other.getZ() == this.getZ();
    }

    public boolean equalsFuzzy(Vector3 other) {
        if (this.equals(other)) {
            return true;
        }
        if (Math.abs(this.getX() - other.getX()) > 1.0E-6) {
            return false;
        }
        if (Math.abs(this.getY() - other.getY()) > 1.0E-6) {
            return false;
        }
        return !(Math.abs(this.getZ() - other.getZ()) > 1.0E-6);
    }

    public int hashCode() {
        return (int)this.getX() ^ (int)this.getZ() << 12 ^ (int)this.getY() << 24;
    }

    public String toString() {
        String x = this.getX() == (double)this.getBlockX() ? "" + this.getBlockX() : "" + this.getX();
        String y = this.getY() == (double)this.getBlockY() ? "" + this.getBlockY() : "" + this.getY();
        String z = this.getZ() == (double)this.getBlockZ() ? "" + this.getBlockZ() : "" + this.getZ();
        return "(" + x + ", " + y + ", " + z + ")";
    }

    public String toParserString() {
        return this.getX() + "," + this.getY() + "," + this.getZ();
    }

    private static final class YzxOrderComparator {
        private static final Comparator<Vector3> YZX_ORDER = (a, b) -> ComparisonChain.start().compare(a.getY(), b.getY()).compare(a.getZ(), b.getZ()).compare(a.getX(), b.getX()).result();

        private YzxOrderComparator() {
        }
    }
}

