/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import javax.annotation.Nullable;

public final class Masks {
    static final AlwaysTrue ALWAYS_TRUE = new AlwaysTrue();
    static final AlwaysFalse ALWAYS_FALSE = new AlwaysFalse();

    private Masks() {
    }

    public static Mask alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static Mask alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static Mask2D alwaysTrue2D() {
        return ALWAYS_TRUE;
    }

    public static Mask negate(Mask mask) {
        return mask.inverse();
    }

    public static Mask2D negate(Mask2D mask) {
        if (mask instanceof AlwaysTrue) {
            return ALWAYS_FALSE;
        }
        if (mask instanceof AlwaysFalse) {
            return ALWAYS_TRUE;
        }
        if (mask instanceof NegatedMask2D) {
            return ((NegatedMask2D)mask).mask;
        }
        Preconditions.checkNotNull((Object)mask);
        return new NegatedMask2D(mask);
    }

    public static Mask asMask(final Mask2D mask) {
        return new AbstractMask(){

            @Override
            public boolean test(BlockVector3 vector) {
                return mask.test(vector.toBlockVector2());
            }

            @Override
            @Nullable
            public Mask2D toMask2D() {
                return mask;
            }

            @Override
            public Mask copy() {
                return Masks.asMask(mask.copy2D());
            }
        };
    }

    protected static class AlwaysTrue
    implements Mask,
    Mask2D {
        protected AlwaysTrue() {
        }

        @Override
        public boolean test(BlockVector3 vector) {
            return true;
        }

        @Override
        public boolean test(BlockVector2 vector) {
            return true;
        }

        @Override
        @Nullable
        public Mask2D toMask2D() {
            return this;
        }

        @Override
        public Mask tryCombine(Mask other) {
            return other;
        }

        @Override
        public Mask tryOr(Mask other) {
            return this;
        }

        @Override
        public Mask copy() {
            return new AlwaysTrue();
        }

        @Override
        public Mask2D copy2D() {
            return new AlwaysTrue();
        }
    }

    protected static class AlwaysFalse
    implements Mask,
    Mask2D {
        protected AlwaysFalse() {
        }

        @Override
        public boolean test(BlockVector3 vector) {
            return false;
        }

        @Override
        public boolean test(BlockVector2 vector) {
            return false;
        }

        @Override
        @Nullable
        public Mask2D toMask2D() {
            return this;
        }

        @Override
        public Mask tryCombine(Mask other) {
            return this;
        }

        @Override
        public Mask tryOr(Mask other) {
            return other;
        }

        @Override
        public Mask copy() {
            return new AlwaysFalse();
        }

        @Override
        public Mask2D copy2D() {
            return new AlwaysFalse();
        }
    }

    private static class NegatedMask2D
    implements Mask2D {
        private final Mask2D mask;

        private NegatedMask2D(Mask2D mask) {
            this.mask = mask;
        }

        @Override
        public boolean test(BlockVector2 vector) {
            return !this.mask.test(vector);
        }

        @Override
        public Mask2D copy2D() {
            return Masks.negate(this.mask.copy2D());
        }
    }

    protected static class NegatedMask
    implements Mask {
        protected final Mask mask;

        private NegatedMask(Mask mask) {
            this.mask = mask;
        }

        @Override
        public boolean test(BlockVector3 vector) {
            return !this.mask.test(vector);
        }

        @Override
        @Nullable
        public Mask2D toMask2D() {
            Mask2D mask2D = this.mask.toMask2D();
            if (mask2D == null) {
                return null;
            }
            return Masks.negate(mask2D);
        }

        @Override
        public Mask copy() {
            return Masks.negate(this.mask.copy());
        }
    }
}

