/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.biome.BiomeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class BiomeMask
extends AbstractExtentMask {
    private final Set<BiomeType> biomes = new HashSet<BiomeType>();

    public BiomeMask(Extent extent, Collection<BiomeType> biomes) {
        super(extent);
        Preconditions.checkNotNull(biomes);
        this.biomes.addAll(biomes);
    }

    public BiomeMask(Extent extent, BiomeType ... biome) {
        this(extent, Arrays.asList((BiomeType[])Preconditions.checkNotNull((Object)biome)));
    }

    public void add(Collection<BiomeType> biomes) {
        Preconditions.checkNotNull(biomes);
        this.biomes.addAll(biomes);
    }

    public void add(BiomeType ... biome) {
        this.add(Arrays.asList((BiomeType[])Preconditions.checkNotNull((Object)biome)));
    }

    public Collection<BiomeType> getBiomes() {
        return this.biomes;
    }

    @Override
    public boolean test(BlockVector3 vector) {
        BiomeType biome = this.getExtent().getBiome(vector);
        return this.biomes.contains(biome);
    }

    @Override
    @Nullable
    public Mask2D toMask2D() {
        return null;
    }

    @Override
    public Mask copy() {
        return new BiomeMask(this.getExtent(), new HashSet<BiomeType>(this.biomes));
    }

    @Override
    public boolean test(Extent extent, BlockVector3 position) {
        BiomeType biome = this.getExtent().getBiome(position);
        return this.biomes.contains(biome);
    }
}

