/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.google.common.collect.ImmutableList;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.SchematicCommands;
import com.sk89q.worldedit.command.argument.Arguments;
import com.sk89q.worldedit.command.util.CommandPermissionsConditionGenerator;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Optional;
import org.enginehub.piston.Command;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.CommandParameters;
import org.enginehub.piston.gen.CommandCallListener;
import org.enginehub.piston.gen.CommandRegistration;
import org.enginehub.piston.inject.Key;
import org.enginehub.piston.internal.RegistrationUtil;
import org.enginehub.piston.part.ArgAcceptingCommandFlag;
import org.enginehub.piston.part.CommandArgument;
import org.enginehub.piston.part.CommandParts;
import org.enginehub.piston.part.NoArgCommandFlag;

public final class SchematicCommandsRegistration
implements CommandRegistration<SchematicCommands>,
CommandPermissionsConditionGenerator.Registration {
    private static final Key<String> string_Key = Key.of(String.class);
    private static final Key<Integer> integer_Key = Key.of(Integer.class);
    private static final Key<Actor> actor_Key = Key.of(Actor.class);
    private static final Key<LocalSession> localSession_Key = Key.of(LocalSession.class);
    private static final Key<Arguments> arguments_Key = Key.of(Arguments.class);
    private CommandManager commandManager;
    private SchematicCommands containerInstance;
    private CommandPermissionsConditionGenerator commandPermissionsConditionGenerator;
    private ImmutableList<CommandCallListener> listeners;
    private final CommandArgument formatNamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"formatName"), (Component)TextComponent.of((String)"Format name.")).defaultsTo((Iterable)ImmutableList.of((Object)"fast")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument filenamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"filename"), (Component)TextComponent.of((String)"File name.")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag overwritePart = CommandParts.flag((char)'o', (Component)TextComponent.of((String)"Overwrite/replace existing clipboard(s)")).build();
    private final CommandArgument fileNamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"fileName"), (Component)TextComponent.of((String)"File name, requires extension.")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument directoryPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"directory"), (Component)TextComponent.of((String)"Directory.")).defaultsTo((Iterable)ImmutableList.of()).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument formatNamePart2 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"formatName"), (Component)TextComponent.of((String)"Format name.")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final NoArgCommandFlag randomRotatePart = CommandParts.flag((char)'r', (Component)TextComponent.of((String)"Apply random rotation to the clipboard")).build();
    private final NoArgCommandFlag allowOverwritePart = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Overwrite an existing file.")).build();
    private final NoArgCommandFlag globalPart = CommandParts.flag((char)'g', (Component)TextComponent.of((String)"Bypasses per-player-schematic folders")).build();
    private final CommandArgument schematicNamePart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"schematicName"), (Component)TextComponent.of((String)"Schematic name. Defaults to name-millis")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument formatNamePart3 = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"formatName"), (Component)TextComponent.of((String)"Format name.")).defaultsTo((Iterable)ImmutableList.of((Object)"sponge")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final ArgAcceptingCommandFlag pagePart = CommandParts.flag((char)'p', (Component)TextComponent.of((String)"Page to view.")).withRequiredArg().argNamed(TranslatableComponent.of((String)"page")).defaultsTo((Iterable)ImmutableList.of((Object)"1")).ofTypes((Collection)ImmutableList.of(integer_Key)).build();
    private final NoArgCommandFlag oldFirstPart = CommandParts.flag((char)'d', (Component)TextComponent.of((String)"Sort by date, oldest first")).build();
    private final NoArgCommandFlag newFirstPart = CommandParts.flag((char)'n', (Component)TextComponent.of((String)"Sort by date, newest first")).build();
    private final ArgAcceptingCommandFlag formatNamePart4 = CommandParts.flag((char)'f', (Component)TextComponent.of((String)"Restricts by format.")).withRequiredArg().argNamed(TranslatableComponent.of((String)"formatName")).defaultsTo((Iterable)ImmutableList.of((Object)"")).ofTypes((Collection)ImmutableList.of(string_Key)).build();
    private final CommandArgument filterPart = CommandParts.arg((TranslatableComponent)TranslatableComponent.of((String)"filter"), (Component)TextComponent.of((String)"Filter for schematics")).defaultsTo((Iterable)ImmutableList.of((Object)"all")).ofTypes((Collection)ImmutableList.of(string_Key)).build();

    private SchematicCommandsRegistration() {
        this.listeners = ImmutableList.of();
    }

    public static SchematicCommandsRegistration builder() {
        return new SchematicCommandsRegistration();
    }

    public SchematicCommandsRegistration commandManager(CommandManager commandManager) {
        this.commandManager = commandManager;
        return this;
    }

    public SchematicCommandsRegistration containerInstance(SchematicCommands containerInstance) {
        this.containerInstance = containerInstance;
        return this;
    }

    @Override
    public SchematicCommandsRegistration commandPermissionsConditionGenerator(CommandPermissionsConditionGenerator commandPermissionsConditionGenerator) {
        this.commandPermissionsConditionGenerator = commandPermissionsConditionGenerator;
        return this;
    }

    public SchematicCommandsRegistration listeners(Collection<CommandCallListener> listeners) {
        this.listeners = ImmutableList.copyOf(listeners);
        return this;
    }

    public void build() {
        this.commandManager.register("loadall", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Load multiple clipboards (paste will randomly choose one)"));
            b.parts((Collection)ImmutableList.of((Object)this.formatNamePart, (Object)this.filenamePart, (Object)this.overwritePart));
            b.action(this::cmd$loadall);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"loadall", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("clear", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Clear your clipboard"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$clear);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"clear", (Class[])new Class[]{Actor.class, LocalSession.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("unload", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Remove a clipboard from your multi-clipboard"));
            b.parts((Collection)ImmutableList.of((Object)this.fileNamePart));
            b.action(this::cmd$unload);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"unload", (Class[])new Class[]{Actor.class, LocalSession.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("move", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"m"));
            b.description((Component)TextComponent.of((String)"Move your loaded schematic"));
            b.parts((Collection)ImmutableList.of((Object)this.directoryPart));
            b.action(this::cmd$move);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"move", (Class[])new Class[]{Actor.class, LocalSession.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("load", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Load a schematic into your clipboard"));
            b.parts((Collection)ImmutableList.of((Object)this.filenamePart, (Object)this.formatNamePart2, (Object)this.randomRotatePart));
            b.action(this::cmd$load);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"load", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("save", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Save your clipboard into a schematic file"));
            b.parts((Collection)ImmutableList.of((Object)this.filenamePart, (Object)this.formatNamePart, (Object)this.allowOverwritePart, (Object)this.globalPart));
            b.action(this::cmd$save);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"save", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("share", b -> {
            b.aliases((Collection)ImmutableList.of());
            b.description((Component)TextComponent.of((String)"Share your clipboard as a schematic online"));
            b.parts((Collection)ImmutableList.of((Object)this.schematicNamePart, (Object)this.formatNamePart3));
            b.action(this::cmd$share);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"share", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("formats", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"listformats", (Object)"f"));
            b.description((Component)TextComponent.of((String)"List available formats"));
            b.parts((Collection)ImmutableList.of());
            b.action(this::cmd$formats);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"formats", (Class[])new Class[]{Actor.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("list", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"all", (Object)"ls"));
            b.description((Component)TextComponent.of((String)"List saved schematics"));
            b.footer((Component)TextComponent.of((String)"Note: Format is not fully verified until loading."));
            b.parts((Collection)ImmutableList.of((Object)this.pagePart, (Object)this.oldFirstPart, (Object)this.newFirstPart, (Object)this.formatNamePart4, (Object)this.filterPart));
            b.action(this::cmd$list);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"list", (Class[])new Class[]{Actor.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class, Arguments.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
        this.commandManager.register("delete", b -> {
            b.aliases((Collection)ImmutableList.of((Object)"d"));
            b.description((Component)TextComponent.of((String)"Delete a saved schematic"));
            b.parts((Collection)ImmutableList.of((Object)this.filenamePart));
            b.action(this::cmd$delete);
            Method commandMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"delete", (Class[])new Class[]{Actor.class, LocalSession.class, String.class});
            Command.Condition condition = this.commandPermissionsConditionGenerator.generateCondition(commandMethod);
            b.condition(condition);
        });
    }

    private int cmd$loadall(CommandParameters parameters) throws FilenameException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"loadall", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.loadall(this.extract$actor(parameters), this.extract$session(parameters), this.extract$formatName(parameters), this.extract$filename(parameters), this.extract$overwrite(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$clear(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"clear", (Class[])new Class[]{Actor.class, LocalSession.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.clear(this.extract$actor(parameters), this.extract$session(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$unload(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"unload", (Class[])new Class[]{Actor.class, LocalSession.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.unload(this.extract$actor(parameters), this.extract$session(parameters), this.extract$fileName(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$move(CommandParameters parameters) throws WorldEditException, IOException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"move", (Class[])new Class[]{Actor.class, LocalSession.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.move(this.extract$actor(parameters), this.extract$session(parameters), this.extract$directory(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$load(CommandParameters parameters) throws FilenameException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"load", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.load(this.extract$actor(parameters), this.extract$session(parameters), this.extract$filename(parameters), this.extract$formatName2(parameters), this.extract$randomRotate(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$save(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"save", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.save(this.extract$actor(parameters), this.extract$session(parameters), this.extract$filename(parameters), this.extract$formatName(parameters), this.extract$allowOverwrite(parameters), this.extract$global(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$share(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"share", (Class[])new Class[]{Actor.class, LocalSession.class, String.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.share(this.extract$actor(parameters), this.extract$session(parameters), this.extract$schematicName(parameters), this.extract$formatName3(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$formats(CommandParameters parameters) {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"formats", (Class[])new Class[]{Actor.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.formats(this.extract$actor(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$list(CommandParameters parameters) throws WorldEditException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"list", (Class[])new Class[]{Actor.class, LocalSession.class, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, String.class, String.class, Arguments.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.list(this.extract$actor(parameters), this.extract$session(parameters), this.extract$page(parameters), this.extract$oldFirst(parameters), this.extract$newFirst(parameters), this.extract$formatName4(parameters), this.extract$filter(parameters), this.extract$arguments(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private int cmd$delete(CommandParameters parameters) throws WorldEditException, IOException {
        Method cmdMethod = RegistrationUtil.getCommandMethod(SchematicCommands.class, (String)"delete", (Class[])new Class[]{Actor.class, LocalSession.class, String.class});
        RegistrationUtil.listenersBeforeCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
        try {
            this.containerInstance.delete(this.extract$actor(parameters), this.extract$session(parameters), this.extract$filename(parameters));
            int result = 1;
            RegistrationUtil.listenersAfterCall(this.listeners, (Method)cmdMethod, (CommandParameters)parameters);
            return result;
        }
        catch (Throwable t) {
            RegistrationUtil.listenersAfterThrow(this.listeners, (Method)cmdMethod, (CommandParameters)parameters, (Throwable)t);
            throw t;
        }
    }

    private Actor extract$actor(CommandParameters parameters) {
        return (Actor)RegistrationUtil.requireOptional(actor_Key, (String)"actor", (Optional)parameters.injectedValue(actor_Key));
    }

    private LocalSession extract$session(CommandParameters parameters) {
        return (LocalSession)RegistrationUtil.requireOptional(localSession_Key, (String)"session", (Optional)parameters.injectedValue(localSession_Key));
    }

    private String extract$formatName(CommandParameters parameters) {
        return (String)this.formatNamePart.value(parameters).asSingle(string_Key);
    }

    private String extract$filename(CommandParameters parameters) {
        return (String)this.filenamePart.value(parameters).asSingle(string_Key);
    }

    private boolean extract$overwrite(CommandParameters parameters) {
        return this.overwritePart.in(parameters);
    }

    private String extract$fileName(CommandParameters parameters) {
        return (String)this.fileNamePart.value(parameters).asSingle(string_Key);
    }

    private String extract$directory(CommandParameters parameters) {
        return (String)this.directoryPart.value(parameters).asSingle(string_Key);
    }

    private String extract$formatName2(CommandParameters parameters) {
        return (String)this.formatNamePart2.value(parameters).asSingle(string_Key);
    }

    private boolean extract$randomRotate(CommandParameters parameters) {
        return this.randomRotatePart.in(parameters);
    }

    private boolean extract$allowOverwrite(CommandParameters parameters) {
        return this.allowOverwritePart.in(parameters);
    }

    private boolean extract$global(CommandParameters parameters) {
        return this.globalPart.in(parameters);
    }

    private String extract$schematicName(CommandParameters parameters) {
        return (String)this.schematicNamePart.value(parameters).asSingle(string_Key);
    }

    private String extract$formatName3(CommandParameters parameters) {
        return (String)this.formatNamePart3.value(parameters).asSingle(string_Key);
    }

    private int extract$page(CommandParameters parameters) {
        return (Integer)this.pagePart.value(parameters).asSingle(integer_Key);
    }

    private boolean extract$oldFirst(CommandParameters parameters) {
        return this.oldFirstPart.in(parameters);
    }

    private boolean extract$newFirst(CommandParameters parameters) {
        return this.newFirstPart.in(parameters);
    }

    private String extract$formatName4(CommandParameters parameters) {
        return (String)this.formatNamePart4.value(parameters).asSingle(string_Key);
    }

    private String extract$filter(CommandParameters parameters) {
        return (String)this.filterPart.value(parameters).asSingle(string_Key);
    }

    private Arguments extract$arguments(CommandParameters parameters) {
        return (Arguments)RegistrationUtil.requireOptional(arguments_Key, (String)"arguments", (Optional)parameters.injectedValue(arguments_Key));
    }
}

