/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jnbt;

import com.fastasyncworldedit.core.jnbt.streamer.StreamDelegate;
import com.fastasyncworldedit.core.jnbt.streamer.ValueReader;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongArrayTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.jnbt.NamedTag;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@Deprecated(forRemoval=true)
public final class NBTInputStream
implements Closeable {
    private final DataInputStream is;
    private byte[] buf;

    public NBTInputStream(InputStream is) {
        this.is = new DataInputStream(is);
    }

    public NBTInputStream(DataInputStream dis) {
        this.is = dis;
    }

    public void mark(int mark) {
        this.is.mark(mark);
    }

    public void reset() throws IOException {
        this.is.reset();
    }

    public NamedTag readNamedTag() throws IOException {
        return this.readNamedTag(0);
    }

    private NamedTag readNamedTag(int depth) throws IOException {
        int type = this.is.readByte() & 0xFF;
        return new NamedTag(this.readNamedTagName(type), this.readTagPayload(type, depth));
    }

    public Tag readTag() throws IOException {
        byte type = this.is.readByte();
        return this.readTagPayload(type, 0);
    }

    public void readNamedTagLazy(StreamDelegate scope) throws IOException {
        try {
            byte type = this.is.readByte();
            if (type == 0) {
                return;
            }
            StreamDelegate child = scope.get(this.is);
            if (child != null) {
                child.acceptRoot(this, type, 0);
            } else {
                this.readTagPayloadLazy(type, 0);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String readNamedTagName(int type) throws IOException {
        if (type != 0) {
            int nameLength = this.is.readShort() & 0xFFFF;
            byte[] nameBytes = new byte[nameLength];
            this.is.readFully(nameBytes);
            return new String(nameBytes, NBTConstants.CHARSET);
        }
        return "";
    }

    public void readTagPayloadLazy(int type, int depth) throws IOException {
        switch (type) {
            case 0: {
                return;
            }
            case 1: {
                this.is.skipBytes(1);
                return;
            }
            case 2: {
                this.is.skipBytes(2);
                return;
            }
            case 3: {
                this.is.skipBytes(4);
                return;
            }
            case 4: {
                this.is.skipBytes(8);
                return;
            }
            case 5: {
                this.is.skipBytes(4);
                return;
            }
            case 6: {
                this.is.skipBytes(8);
                return;
            }
            case 8: {
                int length = this.is.readShort() & 0xFFFF;
                this.is.skipBytes(length);
                return;
            }
            case 7: {
                this.is.skipBytes(this.is.readInt());
                return;
            }
            case 9: {
                byte childType = this.is.readByte();
                int length = this.is.readInt();
                for (int i = 0; i < length; ++i) {
                    this.readTagPayloadLazy(childType, depth + 1);
                }
                return;
            }
            case 10: {
                ++depth;
                while (true) {
                    byte childType;
                    if ((childType = this.is.readByte()) == 0) {
                        return;
                    }
                    this.is.skipBytes(this.is.readShort() & 0xFFFF);
                    this.readTagPayloadLazy(childType, depth + 1);
                }
            }
            case 11: {
                this.is.skipBytes(this.is.readInt() << 2);
                return;
            }
            case 12: {
                this.is.skipBytes(this.is.readInt() << 3);
                return;
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    public void readTagPayloadLazy(int type, int depth, StreamDelegate scope) throws IOException {
        switch (type) {
            case 0: {
                return;
            }
            case 1: {
                ValueReader value = scope.getValueReader();
                if (value == null) {
                    value = scope.getElemReader();
                }
                if (value != null) {
                    value.applyInt(0, this.is.readByte());
                } else {
                    this.is.skipBytes(1);
                }
                return;
            }
            case 2: {
                ValueReader value = scope.getValueReader();
                if (value == null) {
                    value = scope.getElemReader();
                }
                if (value != null) {
                    value.applyInt(0, this.is.readShort());
                } else {
                    this.is.skipBytes(2);
                }
                return;
            }
            case 3: {
                ValueReader value = scope.getValueReader();
                if (value == null) {
                    value = scope.getElemReader();
                }
                if (value != null) {
                    value.applyInt(0, this.is.readInt());
                } else {
                    this.is.skipBytes(4);
                }
                return;
            }
            case 4: {
                ValueReader value = scope.getValueReader();
                if (value == null) {
                    value = scope.getElemReader();
                }
                if (value != null) {
                    value.applyLong(0, this.is.readLong());
                } else {
                    this.is.skipBytes(8);
                }
                return;
            }
            case 5: {
                ValueReader value = scope.getValueReader();
                if (value == null) {
                    value = scope.getElemReader();
                }
                if (value != null) {
                    value.applyFloat(0, this.is.readFloat());
                } else {
                    this.is.skipBytes(4);
                }
                return;
            }
            case 6: {
                ValueReader value = scope.getValueReader();
                if (value == null) {
                    value = scope.getElemReader();
                }
                if (value != null) {
                    value.applyDouble(0, this.is.readDouble());
                } else {
                    this.is.skipBytes(8);
                }
                return;
            }
            case 8: {
                ValueReader value = scope.getValueReader();
                if (value == null) {
                    value = scope.getElemReader();
                }
                int length = this.is.readShort() & 0xFFFF;
                if (value != null) {
                    byte[] bytes = new byte[length];
                    this.is.readFully(bytes);
                    value.apply(0, new String(bytes, NBTConstants.CHARSET));
                } else {
                    this.is.skipBytes(length);
                }
                return;
            }
            case 9: {
                byte childType = this.is.readByte();
                int length = this.is.readInt();
                scope.acceptInfo(length, childType);
                ValueReader valueReader = scope.getValueReader();
                if (valueReader != null) {
                    List<Object> tagList = this.readListRaw(depth, childType, length);
                    valueReader.apply(0, tagList);
                    return;
                }
                valueReader = scope.getElemReader();
                if (valueReader != null) {
                    for (int i = 0; i < length; ++i) {
                        valueReader.apply(i, this.readTagPayloadRaw(childType, depth + 1));
                    }
                    return;
                }
                StreamDelegate child = scope.get0();
                if (child == null) {
                    for (int i = 0; i < length; ++i) {
                        this.readTagPayloadLazy(childType, depth + 1);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        this.readTagPayloadLazy(childType, depth + 1, child);
                    }
                }
                return;
            }
            case 10: {
                scope.acceptInfo(-1, 1);
                ValueReader valueReader = scope.getValueReader();
                if (valueReader != null) {
                    valueReader.apply(0, this.readTagPayloadRaw(type, depth));
                    return;
                }
                valueReader = scope.getElemReader();
                if (valueReader != null) {
                    int i = 0;
                    while (true) {
                        byte childType;
                        if ((childType = this.is.readByte()) == 0) {
                            return;
                        }
                        String key = this.readNamedTagName(childType);
                        Object value = this.readTagPayloadRaw(childType, depth + 1);
                        AbstractMap.SimpleEntry<String, Object> entry = new AbstractMap.SimpleEntry<String, Object>(key, value);
                        valueReader.apply(i, entry);
                        ++i;
                    }
                }
                while (true) {
                    byte childType;
                    if ((childType = this.is.readByte()) == 0) {
                        return;
                    }
                    StreamDelegate child = scope.get(this.is);
                    if (child == null) {
                        this.readTagPayloadLazy(childType, depth + 1);
                        continue;
                    }
                    this.readTagPayloadLazy(childType, depth + 1, child);
                }
            }
            case 7: {
                int length = this.is.readInt();
                scope.acceptInfo(length, 1);
                if (scope.acceptLazy(length, this)) {
                    return;
                }
                ValueReader valueReader = scope.getValueReader();
                if (valueReader != null) {
                    byte[] arr = new byte[length];
                    this.is.readFully(arr);
                    valueReader.apply(0, arr);
                    return;
                }
                valueReader = scope.getElemReader();
                if (valueReader != null) {
                    int i = 0;
                    DataInputStream dis = this.is;
                    if (length > 1024) {
                        if (this.buf == null) {
                            this.buf = new byte[1024];
                        }
                        for (int left = length; left > 1024; left -= 1024) {
                            dis.readFully(this.buf);
                            for (byte b : this.buf) {
                                valueReader.applyInt(i++, b & 0xFF);
                            }
                        }
                    }
                    while (i < length) {
                        valueReader.applyInt(i, dis.read());
                        ++i;
                    }
                    return;
                }
                this.is.skipBytes(length);
                return;
            }
            case 11: {
                int length = this.is.readInt();
                scope.acceptInfo(length, 3);
                if (scope.acceptLazy(length, this)) {
                    return;
                }
                ValueReader valueReader = scope.getValueReader();
                if (valueReader != null) {
                    valueReader.apply(0, this.readIntArrayRaw(length));
                    return;
                }
                valueReader = scope.getElemReader();
                if (valueReader != null) {
                    for (int i = 0; i < length; ++i) {
                        valueReader.applyInt(i, this.is.readInt());
                    }
                    return;
                }
                this.is.skipBytes(length << 2);
                return;
            }
            case 12: {
                int length = this.is.readInt();
                scope.acceptInfo(length, 4);
                if (scope.acceptLazy(length, this)) {
                    return;
                }
                ValueReader valueReader = scope.getValueReader();
                if (valueReader != null) {
                    valueReader.apply(0, this.readLongArrayRaw(length));
                    return;
                }
                valueReader = scope.getElemReader();
                if (valueReader != null) {
                    for (int i = 0; i < length; ++i) {
                        valueReader.applyLong(i, this.is.readLong());
                    }
                    return;
                }
                this.is.skipBytes(length << 3);
                return;
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    private List<Object> readListRaw(int depth, int childType, int length) throws IOException {
        ArrayList<Object> tagList = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            Object tag = this.readTagPayloadRaw(childType, depth + 1);
            if (tag == null) {
                throw new IOException("TAG_End not permitted in a list.");
            }
            tagList.add(tag);
        }
        return tagList;
    }

    public static int getSize(int type) {
        switch (type) {
            default: {
                return 1;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return 2;
            }
            case 3: 
            case 5: {
                return 4;
            }
            case 4: 
            case 6: 
        }
        return 8;
    }

    public Object readTagPayloadRaw(int type, int depth) throws IOException {
        switch (type) {
            case 0: {
                if (depth == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return null;
            }
            case 1: {
                return this.is.readByte();
            }
            case 2: {
                return this.is.readShort();
            }
            case 3: {
                return this.is.readInt();
            }
            case 4: {
                return this.is.readLong();
            }
            case 5: {
                return Float.valueOf(this.is.readFloat());
            }
            case 6: {
                return this.is.readDouble();
            }
            case 7: {
                int length = this.is.readInt();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return bytes;
            }
            case 8: {
                int length = this.is.readShort() & 0xFFFF;
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new String(bytes, NBTConstants.CHARSET);
            }
            case 9: {
                byte childType = this.is.readByte();
                int length = this.is.readInt();
                return this.readListRaw(depth, childType, length);
            }
            case 10: {
                HashMap<String, Object> tagMap = new HashMap<String, Object>();
                while (true) {
                    byte childType;
                    if ((childType = this.is.readByte()) == 0) {
                        return tagMap;
                    }
                    String name = this.readNamedTagName(childType);
                    Object value = this.readTagPayloadRaw(childType, depth + 1);
                    tagMap.put(name, value);
                }
            }
            case 11: {
                int length = this.is.readInt();
                return this.readIntArrayRaw(length);
            }
            case 12: {
                int length = this.is.readInt();
                return this.readLongArrayRaw(length);
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    private int[] readIntArrayRaw(int length) throws IOException {
        int[] data = new int[length];
        if (this.buf == null) {
            this.buf = new byte[1024];
        }
        int index = 0;
        while (length > 0) {
            int toRead = Math.min(length << 2, this.buf.length);
            this.is.readFully(this.buf, 0, toRead);
            int i = 0;
            while (i < toRead) {
                data[index] = ((this.buf[i] & 0xFF) << 24) + ((this.buf[i + 1] & 0xFF) << 16) + ((this.buf[i + 2] & 0xFF) << 8) + (this.buf[i + 3] & 0xFF);
                i += 4;
                ++index;
            }
            length -= toRead;
        }
        return data;
    }

    private long[] readLongArrayRaw(int length) throws IOException {
        long[] data = new long[length];
        if (this.buf == null) {
            this.buf = new byte[1024];
        }
        int index = 0;
        while (length > 0) {
            int toRead = Math.min(length << 3, this.buf.length);
            this.is.readFully(this.buf, 0, toRead);
            int i = 0;
            while (i < toRead) {
                data[index] = (long)this.buf[i] << 56 | (long)(this.buf[i + 1] & 0xFF) << 48 | (long)(this.buf[i + 2] & 0xFF) << 40 | (long)(this.buf[i + 3] & 0xFF) << 32 | (long)(this.buf[i + 4] & 0xFF) << 24 | (long)((this.buf[i + 5] & 0xFF) << 16) | (long)((this.buf[i + 6] & 0xFF) << 8) | (long)(this.buf[i + 7] & 0xFF);
                i += 8;
                ++index;
            }
            length -= toRead;
        }
        return data;
    }

    private Tag readTagPayload(int type, int depth) throws IOException {
        switch (type) {
            case 0: {
                if (depth == 0) {
                    throw new IOException("TAG_End found without a TAG_Compound/TAG_List tag preceding it.");
                }
                return new EndTag();
            }
            case 1: {
                return new ByteTag(this.is.readByte());
            }
            case 2: {
                return new ShortTag(this.is.readShort());
            }
            case 3: {
                return new IntTag(this.is.readInt());
            }
            case 4: {
                return new LongTag(this.is.readLong());
            }
            case 5: {
                return new FloatTag(this.is.readFloat());
            }
            case 6: {
                return new DoubleTag(this.is.readDouble());
            }
            case 7: {
                int length = this.is.readInt();
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new ByteArrayTag(bytes);
            }
            case 8: {
                int length = this.is.readShort() & 0xFFFF;
                byte[] bytes = new byte[length];
                this.is.readFully(bytes);
                return new StringTag(new String(bytes, NBTConstants.CHARSET));
            }
            case 9: {
                byte childType = this.is.readByte();
                int length = this.is.readInt();
                ArrayList<Tag> tagList = new ArrayList<Tag>();
                for (int i = 0; i < length; ++i) {
                    Tag tag = this.readTagPayload(childType, depth + 1);
                    if (tag instanceof EndTag) {
                        throw new IOException("TAG_End not permitted in a list.");
                    }
                    tagList.add(tag);
                }
                return new ListTag(NBTUtils.getTypeClass(childType), tagList);
            }
            case 10: {
                NamedTag namedTag;
                Tag tag;
                HashMap<String, Tag> tagMap = new HashMap<String, Tag>();
                while (!((tag = (namedTag = this.readNamedTag(depth + 1)).getTag()) instanceof EndTag)) {
                    tagMap.put(namedTag.getName(), tag);
                }
                return new CompoundTag(tagMap);
            }
            case 11: {
                int length = this.is.readInt();
                int[] data = new int[length];
                for (int i = 0; i < length; ++i) {
                    data[i] = this.is.readInt();
                }
                return new IntArrayTag(data);
            }
            case 12: {
                int length = this.is.readInt();
                long[] longData = new long[length];
                for (int i = 0; i < length; ++i) {
                    longData[i] = this.is.readLong();
                }
                return new LongArrayTag(longData);
            }
        }
        throw new IOException("Invalid tag type: " + type + ".");
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public Iterator<CompoundTag> toIterator() {
        return new Iterator<CompoundTag>(){
            private CompoundTag last = this.read();

            public CompoundTag read() {
                try {
                    return (CompoundTag)NBTInputStream.this.readTag();
                }
                catch (Exception exception) {
                    try {
                        NBTInputStream.this.is.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.last != null || (this.last = this.read()) != null;
            }

            @Override
            public CompoundTag next() {
                CompoundTag tmp = this.last;
                if (tmp == null) {
                    tmp = this.read();
                }
                this.last = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("CANNOT REMOVE");
            }
        };
    }
}

