/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

public class MultiFuture
implements Future<Object[]> {
    private final List<Future<?>> futures;

    public MultiFuture(List<Future<?>> futures) {
        this.futures = futures;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.futures.stream().allMatch(f -> f.cancel(mayInterruptIfRunning));
    }

    @Override
    public boolean isCancelled() {
        return this.futures.stream().allMatch(Future::isCancelled);
    }

    @Override
    public boolean isDone() {
        return this.futures.stream().allMatch(Future::isDone);
    }

    @Override
    public Object[] get() {
        return this.futures.stream().map(f -> {
            try {
                return f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                return e;
            }
        }).toArray();
    }

    @Override
    public Object[] get(long timeout, @Nonnull TimeUnit unit) {
        return this.futures.stream().map(f -> {
            try {
                return f.get(timeout / (long)this.futures.size(), unit);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                return e;
            }
        }).toArray();
    }
}

