/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.util;

import com.fastasyncworldedit.core.util.ReflectionUtils;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExtentTraverser<T extends Extent> {
    private final T root;
    private final ExtentTraverser<T> parent;

    public ExtentTraverser(@Nonnull T root) {
        this(root, null);
    }

    public ExtentTraverser(@Nonnull T root, ExtentTraverser<T> parent) {
        this.root = root;
        this.parent = parent;
    }

    public boolean exists() {
        return this.root != null;
    }

    @Nullable
    public T get() {
        return this.root;
    }

    public boolean setNext(T next) {
        try {
            Field field = AbstractDelegateExtent.class.getDeclaredField("extent");
            ReflectionUtils.setFailsafeFieldValue(field, this.root, next);
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public ExtentTraverser<T> last() {
        ExtentTraverser<T> last = this;
        for (ExtentTraverser<T> traverser = this; traverser != null && traverser.get() instanceof AbstractDelegateExtent; traverser = traverser.next()) {
            last = traverser;
        }
        return last;
    }

    @Nullable
    public <U extends Extent> U findAndGet(Class<U> clazz) {
        ExtentTraverser<U> traverser = this.find(clazz);
        return traverser != null ? (U)traverser.get() : null;
    }

    public <U extends Extent> ExtentTraverser<U> find(Class<U> clazz) {
        try {
            for (ExtentTraverser<T> value = this; value != null; value = value.next()) {
                if (!clazz.isAssignableFrom(value.root.getClass())) continue;
                return value;
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public <U extends Extent> ExtentTraverser<U> find(Object object) {
        try {
            for (ExtentTraverser<T> value = this; value != null; value = value.next()) {
                if (value.root != object) continue;
                return value;
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public ExtentTraverser<T> previous() {
        return this.parent;
    }

    public ExtentTraverser<T> next() {
        try {
            if (this.root instanceof AbstractDelegateExtent) {
                AbstractDelegateExtent root = (AbstractDelegateExtent)this.root;
                Extent value = root.getExtent();
                if (value == null) {
                    return null;
                }
                return new ExtentTraverser<Extent>(value, this);
            }
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

