/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.registry.state;

import com.fastasyncworldedit.core.registry.state.PropertyKey;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;

public class PropertyKeySet
implements Set<PropertyKey> {
    private final BitSet bits = new BitSet(PropertyKey.getCount());

    public static PropertyKeySet empty() {
        return new PropertyKeySet();
    }

    public static PropertyKeySet ofCollection(Collection<? extends PropertyKey> collection) {
        PropertyKeySet set = new PropertyKeySet();
        if (collection instanceof PropertyKeySet) {
            PropertyKeySet pks = (PropertyKeySet)collection;
            set.bits.or(pks.bits);
            return set;
        }
        for (PropertyKey propertyKey : collection) {
            set.bits.set(propertyKey.getId());
        }
        return set;
    }

    public static PropertyKeySet of(PropertyKey propertyKey) {
        PropertyKeySet set = new PropertyKeySet();
        set.bits.set(propertyKey.getId());
        return set;
    }

    public static PropertyKeySet of(PropertyKey ... propertyKeys) {
        return PropertyKeySet.ofCollection(Arrays.asList(propertyKeys));
    }

    @Override
    public int size() {
        return this.bits.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof PropertyKey)) {
            return false;
        }
        PropertyKey pk = (PropertyKey)o;
        return this.bits.get(pk.getId());
    }

    @Override
    @Nonnull
    public Iterator<PropertyKey> iterator() {
        return new PropertyKeyIterator();
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        T[] array;
        int cardinality = this.bits.cardinality();
        if (cardinality > a.length) {
            array = Arrays.copyOf(a, cardinality);
        } else {
            array = a;
            if (a.length > cardinality) {
                array[cardinality] = null;
            }
        }
        Iterator<PropertyKey> iter = this.iterator();
        for (int i = 0; i < array.length && iter.hasNext(); ++i) {
            array[i] = iter.next();
        }
        return array;
    }

    @Override
    public boolean add(PropertyKey propertyKey) {
        if (this.bits.get(propertyKey.getId())) {
            return false;
        }
        this.bits.set(propertyKey.getId());
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof PropertyKey)) {
            return false;
        }
        PropertyKey pk = (PropertyKey)o;
        if (!this.bits.get(pk.getId())) {
            return false;
        }
        this.bits.clear(pk.getId());
        return true;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        if (c instanceof PropertyKeySet) {
            PropertyKeySet pks = (PropertyKeySet)c;
            return pks.bits.intersects(this.bits);
        }
        for (Object o : c) {
            if (!(o instanceof PropertyKey)) {
                return false;
            }
            PropertyKey pk = (PropertyKey)o;
            if (this.bits.get(pk.getId())) continue;
            return false;
        }
        return false;
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends PropertyKey> c) {
        int cardinality = this.bits.cardinality();
        if (c instanceof PropertyKeySet) {
            PropertyKeySet pks = (PropertyKeySet)c;
            this.bits.or(pks.bits);
        } else {
            for (PropertyKey propertyKey : c) {
                this.bits.set(propertyKey.getId());
            }
        }
        return cardinality != this.bits.cardinality();
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        BitSet removal;
        int cardinality = this.bits.cardinality();
        if (c instanceof PropertyKeySet) {
            PropertyKeySet pks = (PropertyKeySet)c;
            removal = pks.bits;
        } else {
            removal = new BitSet(this.bits.length());
            for (PropertyKey key : this) {
                if (c.contains(key)) continue;
                removal.set(key.getId());
            }
        }
        this.bits.and(removal);
        return cardinality != this.bits.cardinality();
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        int cardinality = this.bits.cardinality();
        if (c instanceof PropertyKeySet) {
            PropertyKeySet pks = (PropertyKeySet)c;
            this.bits.andNot(pks.bits);
        } else {
            for (Object o : c) {
                if (!(o instanceof PropertyKey)) continue;
                PropertyKey pk = (PropertyKey)o;
                this.bits.clear(pk.getId());
            }
        }
        return cardinality != this.bits.cardinality();
    }

    @Override
    public void clear() {
        this.bits.clear();
    }

    private class PropertyKeyIterator
    implements Iterator<PropertyKey> {
        private int current;

        private PropertyKeyIterator() {
            this.current = PropertyKeySet.this.bits.nextSetBit(0);
        }

        @Override
        public boolean hasNext() {
            return this.current >= 0;
        }

        @Override
        public PropertyKey next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PropertyKey next = PropertyKey.getById(this.current);
            this.current = PropertyKeySet.this.bits.nextSetBit(this.current + 1);
            return next;
        }
    }
}

