/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue.implementation.blocks;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.queue.IBlocks;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public abstract class CharBlocks
implements IBlocks {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    protected static final Section FULL = new Section(){

        @Override
        public char[] get(CharBlocks blocks, int layer) {
            return blocks.blocks[layer];
        }

        @Override
        public char[] get(CharBlocks blocks, int layer, boolean aggressive) {
            return blocks.blocks[layer];
        }

        @Override
        public boolean isFull() {
            return true;
        }
    };
    protected static final Section EMPTY = new Section(){

        @Override
        public char[] get(CharBlocks blocks, int layer) {
            return this.get(blocks, layer, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public char[] get(CharBlocks blocks, int layer, boolean aggressive) {
            Object object = blocks.sectionLocks[layer];
            synchronized (object) {
                if (blocks.sections[layer] == FULL) {
                    return FULL.get(blocks, layer);
                }
                char[] arr = blocks.blocks[layer];
                if (arr == null) {
                    blocks.blocks[layer] = blocks.update(layer, null, aggressive);
                    arr = blocks.blocks[layer];
                    if (arr == null) {
                        throw new IllegalStateException("Array cannot be null: " + String.valueOf(blocks.getClass()));
                    }
                } else {
                    blocks.blocks[layer] = blocks.update(layer, arr, aggressive);
                    if (blocks.blocks[layer] == null) {
                        throw new IllegalStateException("Array cannot be null (update): " + String.valueOf(blocks.getClass()));
                    }
                }
                if (blocks.blocks[layer] != null) {
                    blocks.sections[layer] = FULL;
                }
                return arr;
            }
        }

        @Override
        public boolean isFull() {
            return false;
        }
    };
    public char[][] blocks;
    public Section[] sections;
    public Object[] sectionLocks;
    protected int minSectionPosition;
    protected int maxSectionPosition;
    protected int sectionCount;

    public CharBlocks(int minSectionPosition, int maxSectionPosition) {
        this.minSectionPosition = minSectionPosition;
        this.maxSectionPosition = maxSectionPosition;
        this.sectionCount = maxSectionPosition - minSectionPosition + 1;
        this.blocks = new char[this.sectionCount][];
        this.sections = new Section[this.sectionCount];
        this.sectionLocks = new Object[this.sectionCount];
        for (int i = 0; i < this.sectionCount; ++i) {
            this.sections[i] = EMPTY;
            this.sectionLocks[i] = new Object();
        }
    }

    @Override
    public synchronized boolean trim(boolean aggressive) {
        boolean result = true;
        for (int i = 0; i < this.sectionCount; ++i) {
            if (!this.sections[i].isFull() && this.blocks[i] != null) {
                this.blocks[i] = null;
                continue;
            }
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trim(boolean aggressive, int layer) {
        boolean result = true;
        Object object = this.sectionLocks[layer];
        synchronized (object) {
            if (!this.sections[layer].isFull() && this.blocks[layer] != null) {
                this.blocks[layer] = null;
            } else {
                result = false;
            }
        }
        return result;
    }

    @Override
    public synchronized IChunkSet reset() {
        for (int i = 0; i < this.sectionCount; ++i) {
            this.sections[i] = EMPTY;
            this.blocks[i] = null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(int layer) {
        Object object = this.sectionLocks[layer -= this.minSectionPosition];
        synchronized (object) {
            this.sections[layer] = EMPTY;
        }
    }

    public char[] update(int layer, char[] data, boolean aggressive) {
        if (data == null) {
            return new char[4096];
        }
        for (int i = 0; i < 4096; ++i) {
            data[i] = this.defaultOrdinal();
        }
        return data;
    }

    @Override
    public boolean hasSection(int layer) {
        return (layer -= this.minSectionPosition) >= 0 && layer < this.sections.length && this.sections[layer].isFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public char[] load(int layer) {
        Object object = this.sectionLocks[layer -= this.minSectionPosition];
        synchronized (object) {
            return this.sections[layer].get(this, layer);
        }
    }

    @Override
    @Nullable
    public char[] loadIfPresent(int layer) {
        if (layer < this.minSectionPosition || layer > this.maxSectionPosition) {
            return null;
        }
        return this.sections[layer -= this.minSectionPosition].isFull() ? this.blocks[layer] : null;
    }

    @Override
    public int getSectionCount() {
        return this.sectionCount;
    }

    @Override
    public int getMaxSectionPosition() {
        return this.maxSectionPosition;
    }

    @Override
    public int getMinSectionPosition() {
        return this.minSectionPosition;
    }

    @Override
    public BlockState getBlock(int x, int y, int z) {
        return BlockTypesCache.states[this.get(x, y, z)];
    }

    public char get(int x, int y, int z) {
        int layer = y >> 4;
        int index = (y & 0xF) << 8 | z << 4 | x;
        if (layer > this.maxSectionPosition || layer < this.minSectionPosition) {
            return this.defaultOrdinal();
        }
        return this.get(layer, index);
    }

    protected abstract char defaultOrdinal();

    public void set(int x, int y, int z, char value) {
        int layer = y >> 4;
        int index = (y & 0xF) << 8 | z << 4 | x;
        try {
            this.set(layer, index, value);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            LOGGER.error("Tried setting block at coordinates (" + x + "," + y + "," + z + ")");
            assert (Fawe.platform() != null);
            LOGGER.error("Layer variable was = {}", (Object)layer, (Object)exception);
        }
    }

    public final char get(int layer, int index) {
        return this.sections[layer - this.minSectionPosition].get(this, layer, index);
    }

    public final void set(int layer, int index, char value) throws ArrayIndexOutOfBoundsException {
        this.sections[layer - this.minSectionPosition].set(this, layer, index, value);
    }

    public static abstract class Section {
        abstract char[] get(CharBlocks var1, int var2);

        abstract char[] get(CharBlocks var1, int var2, boolean var3);

        public abstract boolean isFull();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final char get(CharBlocks blocks, int layer, int index) {
            int normalized = layer - blocks.minSectionPosition;
            char[] section = this.get(blocks, normalized);
            if (section == null) {
                Object object = blocks.sectionLocks[normalized];
                synchronized (object) {
                    blocks.reset(layer);
                    section = EMPTY.get(blocks, normalized, false);
                }
            }
            return section[index];
        }

        public final synchronized void set(CharBlocks blocks, int layer, int index, char value) {
            this.get((CharBlocks)blocks, (int)(layer -= blocks.minSectionPosition))[index] = value;
        }
    }
}

