/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.queue;

import com.fastasyncworldedit.core.extent.filter.block.ChunkFilterBlock;
import com.fastasyncworldedit.core.extent.processor.IBatchProcessorHolder;
import com.fastasyncworldedit.core.queue.Filter;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkCache;
import com.fastasyncworldedit.core.queue.IChunkExtent;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.queue.Trimable;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import java.io.Flushable;
import java.util.Set;
import java.util.concurrent.Future;
import javax.annotation.Nullable;

public interface IQueueExtent<T extends IChunk>
extends Flushable,
Trimable,
IChunkExtent<T>,
IBatchProcessorHolder {
    @Override
    default public boolean isQueueEnabled() {
        return true;
    }

    @Override
    public void enableQueue();

    @Override
    public void disableQueue();

    public void init(Extent var1, IChunkCache<IChunkGet> var2, IChunkCache<IChunkSet> var3);

    public IChunkGet getCachedGet(int var1, int var2);

    public IChunkSet getCachedSet(int var1, int var2);

    public <V extends Future<V>> V submit(T var1);

    @Override
    default public BlockVector3 getMinimumPoint() {
        return BlockVector3.at(-30000000, this.getMinY(), -30000000);
    }

    @Override
    default public BlockVector3 getMaximumPoint() {
        return BlockVector3.at(30000000, this.getMaxY(), 30000000);
    }

    public void setFastMode(boolean var1);

    public boolean isFastMode();

    public T create(boolean var1);

    default public T wrap(T root) {
        return root;
    }

    @Override
    @Nullable
    default public Operation commit() {
        this.flush();
        return null;
    }

    @Override
    public void flush();

    public ChunkFilterBlock initFilterBlock();

    public int size();

    public boolean isEmpty();

    default public ChunkFilterBlock apply(ChunkFilterBlock block, Filter filter, Region region, int chunkX, int chunkZ, boolean full) {
        if (!filter.appliesChunk(chunkX, chunkZ)) {
            return block;
        }
        Object chunk = this.getOrCreateChunk(chunkX, chunkZ);
        Object newChunk = filter.applyChunk(chunk, region);
        if (newChunk != null) {
            chunk = newChunk;
            if (block == null) {
                block = this.initFilterBlock();
            }
            chunk.filterBlocks(filter, block, region, full);
        }
        this.submit(chunk);
        return block;
    }

    @Override
    default public <T extends Filter> T apply(Region region, T filter, boolean full) {
        Set<BlockVector2> chunks = region.getChunks();
        ChunkFilterBlock block = null;
        for (BlockVector2 chunk : chunks) {
            block = this.apply(block, filter, region, chunk.getX(), chunk.getZ(), full);
        }
        this.flush();
        return filter;
    }
}

