/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.math.random;

import com.fastasyncworldedit.core.math.random.SimpleRandom;

public class Linear3DRandom
implements SimpleRandom {
    private final int xScale;
    private final int yScale;
    private final int zScale;

    public Linear3DRandom(int xScale, int yScale, int zScale) {
        this.xScale = xScale;
        this.yScale = yScale;
        this.zScale = zScale;
    }

    @Override
    public double nextDouble(int x, int y, int z) {
        return this.nextDouble(x, y, z, 1.0);
    }

    @Override
    public double nextDouble(int x, int y, int z, double bound) {
        double index = (Linear3DRandom.doubleDiv(x, this.xScale) + Linear3DRandom.doubleDiv(y, this.yScale) + Linear3DRandom.doubleDiv(z, this.zScale)) % bound;
        if (index < 0.0) {
            index += bound;
        }
        return index;
    }

    static double doubleDiv(double dividend, double divisor) {
        return Math.nextUp(dividend) / divisor;
    }

    @Override
    public int nextInt(int x, int y, int z, int bound) {
        int index = (Math.floorDiv(x, this.xScale) + Math.floorDiv(y, this.yScale) + Math.floorDiv(z, this.zScale)) % bound;
        if (index < 0) {
            index += bound;
        }
        return index;
    }
}

