/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.math.heightmap;

import com.fastasyncworldedit.core.math.IntPair;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.math.heightmap.ArrayHeightMap;
import com.fastasyncworldedit.core.math.heightmap.FlatScalableHeightMap;
import com.fastasyncworldedit.core.math.heightmap.HeightMap;
import com.fastasyncworldedit.core.util.MainUtil;
import com.fastasyncworldedit.core.util.MathMan;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;

public class ScalableHeightMap
implements HeightMap {
    public int size2;
    public int size;

    public ScalableHeightMap() {
        this.setSize(5);
    }

    @Override
    public void setSize(int size) {
        this.size = size;
        this.size2 = size * size;
    }

    @Override
    public double getHeight(int x, int z) {
        int dz;
        int dx = Math.abs(x);
        int d2 = dx * dx + (dz = Math.abs(z)) * dz;
        if (d2 > this.size2) {
            return 0.0;
        }
        return Math.max(0.0f, (float)this.size - MathMan.sqrtApprox(d2));
    }

    public static ScalableHeightMap fromShape(Shape shape) {
        return switch (shape.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> new ScalableHeightMap();
            case 1 -> new FlatScalableHeightMap();
        };
    }

    public static ScalableHeightMap fromClipboard(Clipboard clipboard, int minY, int maxY) {
        BlockVector3 dim = clipboard.getDimensions();
        char[][] heightArray = new char[dim.getBlockX()][dim.getBlockZ()];
        int clipMinX = clipboard.getMinimumPoint().getBlockX();
        int clipMinZ = clipboard.getMinimumPoint().getBlockZ();
        int clipMinY = clipboard.getMinimumPoint().getBlockY();
        int clipMaxY = clipboard.getMaximumPoint().getBlockY();
        int clipHeight = clipMaxY - clipMinY + 1;
        HashSet<IntPair> visited = new HashSet<IntPair>();
        MutableBlockVector3 bv = new MutableBlockVector3();
        for (BlockVector3 pos : clipboard.getRegion()) {
            IntPair pair = new IntPair(pos.getBlockX(), pos.getBlockZ());
            if (visited.contains(pair)) continue;
            visited.add(pair);
            int xx = pos.getBlockX();
            int zz = pos.getBlockZ();
            int highestY = clipMinY;
            bv.setComponents(pos);
            for (int y = clipMinY; y <= clipMaxY; ++y) {
                bv.mutY(y);
                BlockState block = clipboard.getBlock(bv);
                if (block.getBlockType().getMaterial().isAir()) continue;
                highestY = y + 1;
            }
            int x = xx - clipMinX;
            int z = zz - clipMinZ;
            heightArray[x][z] = (char)Math.min(clipMaxY, (maxY - minY + 1) * (highestY - clipMinY) / clipHeight);
        }
        return new ArrayHeightMap(heightArray, maxY - minY + 1);
    }

    public static ScalableHeightMap fromPNG(InputStream stream) throws IOException {
        BufferedImage heightFile = MainUtil.readImage(stream);
        int width = heightFile.getWidth();
        int length = heightFile.getHeight();
        char[][] array = new char[width][length];
        double third = 0.3333333333333333;
        double alphaInverse = 0.00392156862745098;
        for (int x = 0; x < width; ++x) {
            for (int z = 0; z < length; ++z) {
                int pixel = heightFile.getRGB(x, z);
                int red = pixel >> 16 & 0xFF;
                int green = pixel >> 8 & 0xFF;
                int blue = pixel & 0xFF;
                int alpha = pixel >> 24 & 0xFF;
                array[x][z] = (char)((double)alpha * ((double)(red + green + blue) * third) * alphaInverse);
            }
        }
        return new ArrayHeightMap(array, 256.0);
    }

    public static enum Shape {
        CONE,
        CYLINDER;

    }
}

