/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.math;

import com.fastasyncworldedit.core.math.LocalBlockVectorSet;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.util.MathMan;
import com.fastasyncworldedit.core.util.collection.BlockVector3Set;
import com.sk89q.worldedit.math.BlockVector3;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class BlockVectorSet
extends AbstractCollection<BlockVector3>
implements BlockVector3Set {
    private final Long2ObjectLinkedOpenHashMap<LocalBlockVectorSet> localSets = new Long2ObjectLinkedOpenHashMap(4);

    @Override
    public int size() {
        int size = 0;
        for (Long2ObjectMap.Entry entry : this.localSets.long2ObjectEntrySet()) {
            size += ((LocalBlockVectorSet)entry.getValue()).size();
        }
        return size;
    }

    public BlockVector3 get(int index) {
        int count = 0;
        for (Long2ObjectMap.Entry entry : this.localSets.long2ObjectEntrySet()) {
            int localIndex;
            MutableBlockVector3 pos;
            LocalBlockVectorSet set = (LocalBlockVectorSet)entry.getValue();
            int size = set.size();
            int newSize = count + size;
            if (newSize > index && (pos = set.getIndex(localIndex = index - count)) != null) {
                long triple = entry.getLongKey();
                int cx = (int)MathMan.untripleWorldCoordX(triple);
                int cy = (int)MathMan.untripleWorldCoordY(triple);
                int cz = (int)MathMan.untripleWorldCoordZ(triple);
                pos.mutX((cx << 11) + pos.getBlockX());
                pos.mutY((cy << 9) + pos.getBlockY());
                pos.mutZ((cz << 11) + pos.getBlockZ());
                return pos.toImmutable();
            }
            count += newSize;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (Long2ObjectMap.Entry entry : this.localSets.long2ObjectEntrySet()) {
            if (((LocalBlockVectorSet)entry.getValue()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(int x, int y, int z) {
        int indexedY = y + 128 >> 9;
        long triple = MathMan.tripleWorldCoord(x >> 11, indexedY, z >> 11);
        LocalBlockVectorSet localMap = (LocalBlockVectorSet)this.localSets.get(triple);
        return localMap != null && localMap.contains(x & 0x7FF, (y + 128 & 0x1FF) - 128, z & 0x7FF);
    }

    @Override
    public void setOffset(int x, int z) {
    }

    @Override
    public void setOffset(int x, int y, int z) {
    }

    @Override
    public boolean containsRadius(int x, int y, int z, int radius) {
        if (radius <= 0) {
            return this.contains(x, y, z);
        }
        if (!this.contains(x - radius, y, z - radius)) {
            return false;
        }
        if (!this.contains(x + radius, y, z + radius)) {
            return false;
        }
        if (!this.contains(x - radius, y, z + radius)) {
            return false;
        }
        if (!this.contains(x + radius, y, z - radius)) {
            return false;
        }
        for (int xx = -radius; xx <= radius; ++xx) {
            int rx = x + xx;
            for (int yy = -radius; yy <= radius; ++yy) {
                int ry = y + yy;
                for (int zz = -radius; zz <= radius; ++zz) {
                    if (!this.contains(rx, ry, z + zz)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof BlockVector3) {
            BlockVector3 v = (BlockVector3)o;
            return this.contains(v.getBlockX(), v.getBlockY(), v.getBlockZ());
        }
        return false;
    }

    @Override
    @Nonnull
    public Iterator<BlockVector3> iterator() {
        ObjectBidirectionalIterator entries = this.localSets.long2ObjectEntrySet().iterator();
        if (!entries.hasNext()) {
            return Collections.emptyIterator();
        }
        return new Iterator<BlockVector3>((ObjectIterator)entries){
            Long2ObjectMap.Entry<LocalBlockVectorSet> entry;
            Iterator<BlockVector3> entryIter;
            final MutableBlockVector3 mutable;
            final /* synthetic */ ObjectIterator val$entries;
            {
                this.val$entries = objectIterator;
                this.entry = (Long2ObjectMap.Entry)this.val$entries.next();
                this.entryIter = ((LocalBlockVectorSet)this.entry.getValue()).iterator();
                this.mutable = new MutableBlockVector3();
            }

            @Override
            public void remove() {
                this.entryIter.remove();
            }

            @Override
            public boolean hasNext() {
                return this.entryIter.hasNext() || this.val$entries.hasNext();
            }

            @Override
            public BlockVector3 next() {
                while (!this.entryIter.hasNext()) {
                    if (!this.val$entries.hasNext()) {
                        throw new NoSuchElementException("End of iterator");
                    }
                    this.entry = (Long2ObjectMap.Entry)this.val$entries.next();
                    this.entryIter = ((LocalBlockVectorSet)this.entry.getValue()).iterator();
                }
                BlockVector3 localPos = this.entryIter.next();
                long triple = this.entry.getLongKey();
                int cx = (int)MathMan.untripleWorldCoordX(triple);
                int cy = (int)MathMan.untripleWorldCoordY(triple);
                int cz = (int)MathMan.untripleWorldCoordZ(triple);
                return this.mutable.setComponents((cx << 11) + localPos.getBlockX(), (cy << 9) + localPos.getBlockY(), (cz << 11) + localPos.getBlockZ());
            }
        };
    }

    @Override
    public boolean add(BlockVector3 vector) {
        return this.add(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Override
    public boolean add(int x, int y, int z) {
        int indexedY = y + 128 >> 9;
        long triple = MathMan.tripleWorldCoord(x >> 11, indexedY, z >> 11);
        LocalBlockVectorSet localMap = (LocalBlockVectorSet)this.localSets.get(triple);
        if (localMap == null) {
            localMap = new LocalBlockVectorSet();
            localMap.setOffset(1024, 1024);
            this.localSets.put(triple, (Object)localMap);
        }
        return localMap.add(x & 0x7FF, (y + 128 & 0x1FF) - 128, z & 0x7FF);
    }

    public boolean remove(int x, int y, int z) {
        int pair = MathMan.pair((short)(x >> 11), (short)(z >> 11));
        LocalBlockVectorSet localMap = (LocalBlockVectorSet)this.localSets.get((long)pair);
        if (localMap != null && localMap.remove(x & 0x7FF, y, z & 0x7FF)) {
            if (localMap.isEmpty()) {
                this.localSets.remove((long)pair);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof BlockVector3) {
            BlockVector3 v = (BlockVector3)o;
            return this.remove(v.getBlockX(), v.getBlockY(), v.getBlockZ());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends BlockVector3> c) {
        boolean result = false;
        for (BlockVector3 blockVector3 : c) {
            result |= this.add(blockVector3);
        }
        return result;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<BlockVector3> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public void clear() {
        this.localSets.clear();
    }
}

