/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.history.changeset;

import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ChangeSetSummary {
    public Map<BlockState, Integer> getBlocks();

    public int getSize();

    default public List<Countable<BlockState>> getBlockDistributionWithData() {
        ArrayList<Countable<BlockState>> list = new ArrayList<Countable<BlockState>>();
        for (Map.Entry<BlockState, Integer> entry : this.getBlocks().entrySet()) {
            list.add(new Countable<BlockState>(entry.getKey(), entry.getValue()));
        }
        return list;
    }

    default public Map<BlockState, Double> getPercents() {
        Map<BlockState, Integer> map = this.getBlocks();
        int count = this.getSize();
        HashMap<BlockState, Double> newMap = new HashMap<BlockState, Double>();
        for (Map.Entry<BlockState, Integer> entry : map.entrySet()) {
            BlockState id = entry.getKey();
            int changes = entry.getValue();
            double percent = (double)((long)changes * 1000L / (long)count) / 10.0;
            newMap.put(id, percent);
        }
        return newMap;
    }
}

