/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.history.changeset;

import com.fastasyncworldedit.core.Fawe;
import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.extent.HistoryExtent;
import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.util.MainUtil;
import com.fastasyncworldedit.core.util.TaskManager;
import com.google.common.util.concurrent.Futures;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EditSessionBuilder;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.history.change.BlockChange;
import com.sk89q.worldedit.history.change.Change;
import com.sk89q.worldedit.history.change.EntityCreate;
import com.sk89q.worldedit.history.change.EntityRemove;
import com.sk89q.worldedit.history.changeset.ChangeSet;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;

public abstract class AbstractChangeSet
implements ChangeSet,
IBatchProcessor {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final World world;
    private final AtomicInteger lastException = new AtomicInteger();
    private final Semaphore workerSemaphore = new Semaphore(1, false);
    private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
    protected volatile boolean closed;

    public AbstractChangeSet(World world) {
        this.world = world;
    }

    public World getWorld() {
        return this.world;
    }

    public void closeAsync() {
        if (this.closed) {
            return;
        }
        TaskManager.taskManager().async(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                LOGGER.catching((Throwable)e);
            }
        });
    }

    @Override
    public void flush() {
        try {
            this.drainQueue(true);
        }
        catch (Exception e) {
            LOGGER.catching((Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flush();
            this.closed = true;
        }
    }

    public abstract void add(int var1, int var2, int var3, int var4, int var5);

    @Override
    public Iterator<Change> backwardIterator() {
        return this.getIterator(false);
    }

    @Override
    public Iterator<Change> forwardIterator() {
        return this.getIterator(true);
    }

    @Override
    public Extent construct(Extent child) {
        return new HistoryExtent(child, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        int y;
        void var10_18;
        Set<CompoundTag> ents;
        Set<UUID> entRemoves;
        int bx = chunk.getX() << 4;
        int bz = chunk.getZ() << 4;
        Map<BlockVector3, CompoundTag> tilesFrom = get.getTiles();
        Map<BlockVector3, CompoundTag> tilesTo = set.getTiles();
        if (!tilesFrom.isEmpty()) {
            for (Map.Entry<BlockVector3, CompoundTag> entry : tilesFrom.entrySet()) {
                BlockState toBlock;
                BlockVector3 blockVector3 = entry.getKey();
                BlockState fromBlock = get.getBlock(blockVector3.getX() & 0xF, blockVector3.getY(), blockVector3.getZ() & 0xF);
                if (fromBlock == (toBlock = set.getBlock(blockVector3.getX() & 0xF, blockVector3.getY(), blockVector3.getZ() & 0xF)) && !tilesTo.containsKey(blockVector3)) continue;
                this.addTileRemove(MainUtil.setPosition(entry.getValue(), entry.getKey().getX(), entry.getKey().getY(), entry.getKey().getZ()));
            }
        }
        if (!tilesTo.isEmpty()) {
            for (Map.Entry<BlockVector3, CompoundTag> entry : tilesTo.entrySet()) {
                BlockVector3 blockVector3 = entry.getKey();
                this.addTileCreate(MainUtil.setPosition(entry.getValue(), blockVector3.getX() + bx, blockVector3.getY(), blockVector3.getZ() + bz));
            }
        }
        if (!(entRemoves = set.getEntityRemoves()).isEmpty()) {
            for (UUID uUID : entRemoves) {
                CompoundTag found = get.getEntity(uUID);
                if (found == null) continue;
                this.addEntityRemove(found);
            }
        }
        if (!(ents = set.getEntities()).isEmpty()) {
            for (CompoundTag tag : ents) {
                this.addEntityCreate(tag);
            }
        }
        int n = get.getMinSectionPosition();
        while (var10_18 <= get.getMaxSectionPosition()) {
            if (set.hasSection((int)var10_18)) {
                char[] blocksGet;
                char[] tmp = get.load((int)var10_18);
                if (tmp == null) {
                    blocksGet = FaweCache.INSTANCE.EMPTY_CHAR_4096;
                } else {
                    blocksGet = new char[4096];
                    System.arraycopy(tmp, 0, blocksGet, 0, 4096);
                }
                char[] blocksSet = new char[4096];
                System.arraycopy(Objects.requireNonNull(set.loadIfPresent((int)var10_18)), 0, blocksSet, 0, 4096);
                void by = var10_18 << 4;
                int index = 0;
                for (y = 0; y < 16; ++y) {
                    int yy = y + by;
                    for (int z = 0; z < 16; ++z) {
                        int zz = z + bz;
                        int x = 0;
                        while (x < 16) {
                            char combinedTo = blocksSet[index];
                            if (combinedTo != '\u0000') {
                                int xx = bx + x;
                                char from = blocksGet[index];
                                if (from == '\u0000') {
                                    from = '\u0001';
                                }
                                char combinedFrom = from;
                                this.add(xx, yy, zz, (int)combinedFrom, combinedTo);
                            }
                            ++x;
                            ++index;
                        }
                    }
                }
            }
            ++var10_18;
        }
        BiomeType[][] biomeTypeArray = set.getBiomes();
        if (biomeTypeArray != null) {
            for (int layer = get.getMinSectionPosition(); layer <= get.getMaxSectionPosition(); ++layer) {
                if (!set.hasBiomes(layer)) continue;
                BiomeType[] biomeSection = biomeTypeArray[layer - set.getMinSectionPosition()];
                int index = 0;
                int yy = layer << 4;
                for (y = 0; y < 16; y += 4) {
                    for (int z = 0; z < 16; z += 4) {
                        int x = 0;
                        while (x < 16) {
                            BiomeType oldBiome;
                            BiomeType newBiome = biomeSection[index];
                            if (newBiome != null && (oldBiome = get.getBiomeType(x, yy + y, z)) != newBiome) {
                                this.addBiomeChange(bx + x, yy + y, bz + z, oldBiome, newBiome);
                            }
                            x += 4;
                            ++index;
                        }
                    }
                }
            }
        }
        return set;
    }

    @Override
    public void postProcess(IChunk chunk, IChunkGet get, IChunkSet set) {
        this.addWriteTask(() -> this.processSet(chunk, get, set));
    }

    @Override
    public Future<?> postProcessSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        return this.addWriteTask(() -> this.processSet(chunk, get, set));
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.READING_SET_BLOCKS;
    }

    public abstract void addTileCreate(CompoundTag var1);

    public abstract void addTileRemove(CompoundTag var1);

    public abstract void addEntityRemove(CompoundTag var1);

    public abstract void addEntityCreate(CompoundTag var1);

    public abstract void addBiomeChange(int var1, int var2, int var3, BiomeType var4, BiomeType var5);

    public Iterator<Change> getIterator(BlockBag blockBag, int mode, boolean redo) {
        return this.getIterator(redo);
    }

    public abstract Iterator<Change> getIterator(boolean var1);

    public EditSession toEditSession(Actor actor) {
        return this.toEditSession(actor, null);
    }

    public EditSession toEditSession(Actor actor, Region[] regions) {
        EditSessionBuilder builder = WorldEdit.getInstance().newEditSessionBuilder().world(this.world).checkMemory(false).changeSetNull().fastMode(false).limitUnprocessed(actor).actor(actor);
        if (!actor.getLimit().RESTRICT_HISTORY_TO_REGIONS) {
            builder = builder.allowedRegionsEverywhere();
        }
        EditSession editSession = builder.build();
        editSession.setSize(1);
        return editSession;
    }

    public void add(EntityCreate change) {
        CompoundTag tag = change.state.getNbtData();
        this.addEntityCreate(MainUtil.setEntityInfo(tag, change.getEntity()));
    }

    public void add(EntityRemove change) {
        CompoundTag tag = change.state.getNbtData();
        this.addEntityRemove(MainUtil.setEntityInfo(tag, change.getEntity()));
    }

    @Override
    public void add(Change change) {
        if (change.getClass() == BlockChange.class) {
            this.add((BlockChange)change);
        } else if (change.getClass() == EntityCreate.class) {
            this.add((EntityCreate)change);
        } else if (change.getClass() == EntityRemove.class) {
            this.add((EntityRemove)change);
        } else {
            LOGGER.error("Unknown change: {}", change.getClass());
        }
    }

    public void add(BlockChange change) {
        try {
            BlockVector3 loc = change.getPosition();
            BaseBlock from = change.getPrevious();
            BaseBlock to = change.getCurrent();
            this.add(loc, from, to);
        }
        catch (Exception e) {
            LOGGER.catching((Throwable)e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty() && this.workerSemaphore.availablePermits() == 1 && this.size() == 0;
    }

    public void add(BlockVector3 loc, BaseBlock from, BaseBlock to) {
        int x = loc.getBlockX();
        int y = loc.getBlockY();
        int z = loc.getBlockZ();
        this.add(x, y, z, from, to);
    }

    public void add(int x, int y, int z, BaseBlock from, BaseBlock to) {
        try {
            CompoundTag nbt;
            if (from.hasNbtData()) {
                nbt = from.getNbtData();
                assert (nbt != null);
                this.addTileRemove(MainUtil.setPosition(nbt, x, y, z));
            }
            if (to.hasNbtData()) {
                nbt = to.getNbtData();
                assert (nbt != null);
                this.addTileCreate(MainUtil.setPosition(nbt, x, y, z));
            }
            int combinedFrom = from.getOrdinal();
            int combinedTo = to.getOrdinal();
            this.add(x, y, z, combinedFrom, combinedTo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void add(int x, int y, int z, int combinedFrom, BaseBlock to) {
        try {
            if (to.hasNbtData()) {
                CompoundTag nbt = to.getNbtData();
                assert (nbt != null);
                this.addTileCreate(MainUtil.setPosition(nbt, x, y, z));
            }
            int combinedTo = to.getInternalId();
            this.add(x, y, z, combinedFrom, combinedTo);
        }
        catch (Exception e) {
            LOGGER.catching((Throwable)e);
        }
    }

    public Future<?> addWriteTask(Runnable writeTask) {
        return this.addWriteTask(writeTask, Fawe.isMainThread());
    }

    public Future<?> addWriteTask(Runnable writeTask, boolean completeNow) {
        Runnable wrappedTask = () -> {
            block3: {
                try {
                    writeTask.run();
                }
                catch (Throwable t) {
                    if (completeNow) {
                        throw t;
                    }
                    int hash = t.getMessage().hashCode();
                    if (this.lastException.getAndSet(hash) == hash) break block3;
                    LOGGER.catching(t);
                }
            }
        };
        if (completeNow) {
            wrappedTask.run();
            return Futures.immediateVoidFuture();
        }
        CompletableFuture task = new CompletableFuture();
        this.queue.add(() -> {
            wrappedTask.run();
            task.complete(null);
        });
        this.triggerWorker();
        return task;
    }

    private void triggerWorker() {
        if (this.workerSemaphore.availablePermits() == 0) {
            return;
        }
        Fawe.instance().getQueueHandler().async(() -> this.drainQueue(false));
    }

    private void drainQueue(boolean ignoreRunningState) {
        if (!this.workerSemaphore.tryAcquire()) {
            if (ignoreRunningState) {
                try {
                    this.workerSemaphore.acquire();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } else {
                return;
            }
        }
        try {
            Runnable next;
            while ((next = this.queue.poll()) != null) {
                next.run();
            }
        }
        finally {
            this.workerSemaphore.release();
        }
    }
}

