/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.function.mask;

import com.fastasyncworldedit.core.function.mask.AdjacentAnyMask;
import com.fastasyncworldedit.core.function.mask.BlockMaskBuilder;
import com.fastasyncworldedit.core.function.mask.CachedMask;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockTypes;

public class SurfaceMask
extends AdjacentAnyMask {
    public SurfaceMask(Extent extent) {
        super(SurfaceMask.getMask(extent), extent.getMinY(), extent.getMaxY());
    }

    private SurfaceMask(CachedMask mask, int minY, int maxY) {
        super(mask, minY, maxY);
    }

    public static AbstractExtentMask getMask(Extent extent) {
        return new BlockMaskBuilder().addTypes(BlockTypes.AIR, BlockTypes.CAVE_AIR, BlockTypes.VOID_AIR).addAll(b -> !b.getMaterial().isMovementBlocker()).build(extent);
    }

    @Override
    public boolean test(BlockVector3 v) {
        return !this.getParentMask().test(v) && super.test(v);
    }

    @Override
    public Mask copy() {
        return new SurfaceMask(this.getParentMask(), this.minY, this.maxY);
    }
}

