/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.transform;

import com.fastasyncworldedit.core.extent.ResettableExtent;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.fastasyncworldedit.core.math.MutableVector3;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.UUID;
import javax.annotation.Nullable;

public class ScaleTransform
extends ResettableExtent {
    private final double dx;
    private final double dy;
    private final double dz;
    private transient MutableVector3 mutable = new MutableVector3();
    private transient int minY;
    private transient int maxy;
    private transient BlockVector3 min;

    public ScaleTransform(Extent parent, double dx, double dy, double dz) {
        super(parent);
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.minY = parent.getMinY();
        this.maxy = parent.getMaxY();
    }

    @Override
    public ResettableExtent setExtent(Extent extent) {
        this.min = null;
        this.mutable = new MutableVector3();
        this.minY = extent.getMinY();
        this.maxy = extent.getMaxY();
        return super.setExtent(extent);
    }

    private MutableVector3 getPos(BlockVector3 pos) {
        if (this.min == null) {
            this.min = pos;
        }
        this.mutable.mutX((double)this.min.getX() + (double)(pos.getX() - this.min.getX()) * this.dx);
        this.mutable.mutY((double)this.min.getY() + (double)(pos.getY() - this.min.getY()) * this.dy);
        this.mutable.mutZ((double)this.min.getZ() + (double)(pos.getZ() - this.min.getZ()) * this.dz);
        return new MutableVector3(this.mutable);
    }

    private MutableVector3 getPos(int x, int y, int z) {
        if (this.min == null) {
            this.min = BlockVector3.at(x, y, z);
        }
        this.mutable.mutX((double)this.min.getX() + (double)(x - this.min.getX()) * this.dx);
        this.mutable.mutY((double)this.min.getY() + (double)(y - this.min.getY()) * this.dy);
        this.mutable.mutZ((double)this.min.getZ() + (double)(z - this.min.getZ()) * this.dz);
        return new MutableVector3(this.mutable);
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        boolean result = false;
        MutableVector3 vector3 = this.getPos(location);
        MutableBlockVector3 pos = new MutableBlockVector3();
        double sx = vector3.getX();
        double sy = vector3.getY();
        double sz = vector3.getZ();
        double ex = sx + this.dx;
        double ey = Math.max((double)this.minY, Math.min((double)this.maxy, sy + this.dy));
        double ez = sz + this.dz;
        pos.mutY(sy);
        while ((double)pos.getY() < ey) {
            pos.mutZ(sz);
            while ((double)pos.getZ() < ez) {
                pos.mutX(sx);
                while ((double)pos.getX() < ex) {
                    if (this.getExtent().contains(pos)) {
                        result |= super.setBlock(pos, block);
                    }
                    pos.mutX(pos.getX() + 1);
                }
                pos.mutZ(pos.getZ() + 1);
            }
            pos.mutY(pos.getY() + 1);
        }
        return result;
    }

    @Override
    public boolean setBiome(BlockVector3 position, BiomeType biome) {
        boolean result = false;
        MutableVector3 vector3 = this.getPos(position);
        MutableBlockVector3 pos = new MutableBlockVector3();
        double sx = vector3.getX();
        double sy = vector3.getY();
        double sz = vector3.getZ();
        double ex = sx + this.dx;
        double ey = Math.max((double)this.minY, Math.min((double)this.maxy, sy + this.dy));
        double ez = sz + this.dz;
        pos.mutY(sy);
        while ((double)pos.getY() < ey) {
            pos.mutZ(sz);
            while ((double)pos.getZ() < ez) {
                pos.mutX(sx);
                while ((double)pos.getX() < ex) {
                    if (this.getExtent().contains(pos)) {
                        result |= super.setBiome(pos, biome);
                    }
                    pos.mutX(pos.getX() + 1);
                }
                pos.mutZ(pos.getZ() + 1);
            }
            pos.mutY(pos.getY() + 1);
        }
        return result;
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x1, int y1, int z1, B block) throws WorldEditException {
        boolean result = false;
        MutableVector3 vector3 = this.getPos(x1, y1, z1);
        MutableBlockVector3 pos = new MutableBlockVector3();
        double sx = vector3.getX();
        double sy = vector3.getY();
        double sz = vector3.getZ();
        double ex = vector3.getX() + this.dx;
        double ey = Math.min((double)this.maxy, sy + this.dy);
        double ez = vector3.getZ() + this.dz;
        pos.mutY(sy);
        while ((double)pos.getY() < ey) {
            pos.mutZ(sz);
            while ((double)pos.getZ() < ez) {
                pos.mutX(sx);
                while ((double)pos.getX() < ex) {
                    if (this.getExtent().contains(pos)) {
                        result |= super.setBlock(pos, block);
                    }
                    pos.mutX(pos.getX() + 1);
                }
                pos.mutZ(pos.getZ() + 1);
            }
            pos.mutY(pos.getY() + 1);
        }
        return result;
    }

    @Override
    public boolean setBiome(int x1, int y1, int z1, BiomeType biome) {
        boolean result = false;
        MutableVector3 vector3 = this.getPos(x1, y1, z1);
        MutableBlockVector3 pos = new MutableBlockVector3();
        double sx = vector3.getX();
        double sy = vector3.getY();
        double sz = vector3.getZ();
        double ex = sx + this.dx;
        double ey = Math.max((double)this.minY, Math.min((double)this.maxy, sy + this.dy));
        double ez = sz + this.dz;
        pos.mutY(sy);
        while ((double)pos.getY() < ey) {
            pos.mutZ(sz);
            while ((double)pos.getZ() < ez) {
                pos.mutX(sx);
                while ((double)pos.getX() < ex) {
                    if (this.getExtent().contains(pos)) {
                        result |= super.setBiome(pos, biome);
                    }
                    pos.mutX(pos.getX() + 1);
                }
                pos.mutZ(pos.getZ() + 1);
            }
            pos.mutY(pos.getY() + 1);
        }
        return result;
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity) {
        Location newLoc = new Location(location.getExtent(), this.getPos(location.getBlockX(), location.getBlockY(), location.getBlockZ()), location.getYaw(), location.getPitch());
        if (!this.getExtent().contains(newLoc.toBlockPoint())) {
            return null;
        }
        return super.createEntity(newLoc, entity);
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity entity, UUID uuid) {
        Location newLoc = new Location(location.getExtent(), this.getPos(location.getBlockX(), location.getBlockY(), location.getBlockZ()), location.getYaw(), location.getPitch());
        if (!this.getExtent().contains(newLoc.toBlockPoint())) {
            return null;
        }
        return super.createEntity(newLoc, entity, uuid);
    }
}

