/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.filter;

import com.fastasyncworldedit.core.queue.Filter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ForkedFilter<T extends ForkedFilter<T>>
implements Filter {
    protected final Map<Thread, T> children;

    public ForkedFilter(T root) {
        if (root != null) {
            this.children = ((ForkedFilter)root).children;
        } else {
            this.children = new ConcurrentHashMap<Thread, T>();
            this.children.put(Thread.currentThread(), this);
        }
    }

    @Override
    public final Filter fork() {
        return this.children.computeIfAbsent(Thread.currentThread(), thread -> this.init());
    }

    public abstract T init();

    @Override
    public void join() {
        for (Map.Entry<Thread, T> entry : this.children.entrySet()) {
            ForkedFilter filter = (ForkedFilter)entry.getValue();
            if (filter == this) continue;
            this.join(filter);
        }
        this.children.clear();
    }

    public abstract void join(T var1);
}

