/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent.filter;

import com.fastasyncworldedit.core.extent.filter.ForkedFilter;
import com.fastasyncworldedit.core.extent.filter.block.FilterBlock;
import com.fastasyncworldedit.core.function.mask.ABlockMask;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.util.Countable;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DistrFilter
extends ForkedFilter<DistrFilter> {
    private final int[] counter = new int[BlockTypesCache.states.length];

    public DistrFilter() {
        super(null);
    }

    private DistrFilter(DistrFilter root) {
        super(root);
    }

    @Override
    public DistrFilter init() {
        return new DistrFilter(this);
    }

    @Override
    public void join(DistrFilter filter) {
        for (int i = 0; i < filter.counter.length; ++i) {
            int n = i;
            this.counter[n] = this.counter[n] + filter.counter[i];
        }
    }

    @Override
    public final void applyBlock(FilterBlock block) {
        int ordinal = block.getOrdinal();
        if (ordinal == 0) {
            ordinal = 1;
        }
        int n = ordinal;
        this.counter[n] = this.counter[n] + 1;
    }

    public int getTotal(ABlockMask mask) {
        int total = 0;
        for (int i = 0; i < this.counter.length; ++i) {
            int value = this.counter[i];
            if (value == 0 || !mask.test(BlockTypesCache.states[i])) continue;
            total += value;
        }
        return total;
    }

    public int getTotal() {
        return Arrays.stream(this.counter).sum();
    }

    public List<Countable<BlockState>> getDistribution() {
        ArrayList<Countable<BlockState>> distribution = new ArrayList<Countable<BlockState>>();
        for (int i = 0; i < this.counter.length; ++i) {
            int count = this.counter[i];
            if (count == 0) continue;
            distribution.add(new Countable<BlockState>(BlockTypesCache.states[i], count));
        }
        Collections.sort(distribution);
        return distribution;
    }

    public List<Countable<BlockType>> getTypeDistribution() {
        int count;
        int i;
        ArrayList<Countable<BlockType>> distribution = new ArrayList<Countable<BlockType>>();
        int[] typeCounter = new int[BlockTypesCache.values.length];
        for (i = 0; i < this.counter.length; ++i) {
            count = this.counter[i];
            if (count == 0) continue;
            BlockState state = BlockTypesCache.states[i];
            int n = state.getBlockType().getInternalId();
            typeCounter[n] = typeCounter[n] + count;
        }
        for (i = 0; i < typeCounter.length; ++i) {
            count = typeCounter[i];
            if (count == 0) continue;
            distribution.add(new Countable<BlockType>(BlockTypesCache.values[i], count));
        }
        Collections.sort(distribution);
        return distribution;
    }

    public void print(Actor actor, long size) {
        for (Countable<BlockState> c : this.getDistribution()) {
            String name = c.getID().toString();
            String str = String.format("%-7s (%.3f%%) %s", c.getAmount(), (double)c.getAmount() / (double)size * 100.0, name);
            actor.printInfo((Component)TextComponent.of((String)str));
        }
    }
}

