/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extent;

import com.fastasyncworldedit.core.extent.processor.ProcessorScope;
import com.fastasyncworldedit.core.limit.PropertyRemap;
import com.fastasyncworldedit.core.queue.IBatchProcessor;
import com.fastasyncworldedit.core.queue.IChunk;
import com.fastasyncworldedit.core.queue.IChunkGet;
import com.fastasyncworldedit.core.queue.IChunkSet;
import com.fastasyncworldedit.core.util.ExtentTraverser;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extension.factory.parser.DefaultBlockParser;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.block.BlockTypesCache;
import com.sk89q.worldedit.world.block.FuzzyBlockState;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class DisallowedBlocksExtent
extends AbstractDelegateExtent
implements IBatchProcessor {
    private static final BlockState RESERVED = BlockTypes.__RESERVED__.getDefaultState();
    private final Set<PropertyRemap<?>> remaps;
    private Set<FuzzyBlockState> blockedStates = null;
    private Set<String> blockedBlocks = null;

    public DisallowedBlocksExtent(Extent extent, Set<String> blockedBlocks, Set<PropertyRemap<?>> remaps) {
        super(extent);
        this.remaps = remaps;
        if (blockedBlocks != null && !blockedBlocks.isEmpty()) {
            blockedBlocks = blockedBlocks.stream().map(s -> s.contains(":") ? s.toLowerCase(Locale.ROOT) : ("minecraft:" + s).toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            this.blockedBlocks = new HashSet<String>();
            for (String block : blockedBlocks) {
                BlockType type;
                Map<Property<?>, Object> values;
                if (block.indexOf(91) == -1 || block.indexOf(93) == -1) {
                    this.blockedBlocks.add(block);
                    continue;
                }
                String[] properties = block.substring(block.indexOf(91) + 1, block.indexOf(93)).split(",");
                if (properties.length == 0 || (values = DefaultBlockParser.parseProperties(type = BlockTypes.get(block.substring(0, block.indexOf(91))), properties, null, true)) == null || values.isEmpty()) continue;
                if (this.blockedStates == null) {
                    this.blockedStates = new HashSet<FuzzyBlockState>();
                }
                this.blockedStates.add(new FuzzyBlockState(type.getDefaultState(), values));
            }
        }
    }

    public <B extends BlockStateHolder<B>> boolean setBlock(BlockVector3 location, B block) throws WorldEditException {
        if (block instanceof BaseBlock || block instanceof BlockState) {
            B newBlock = this.checkBlock(block);
            if (newBlock.getBlockType() == BlockTypes.__RESERVED__) {
                return false;
            }
            return super.setBlock(location, newBlock);
        }
        return super.setBlock(location, block);
    }

    @Override
    public <B extends BlockStateHolder<B>> boolean setBlock(int x, int y, int z, B block) throws WorldEditException {
        if (block instanceof BaseBlock || block instanceof BlockState) {
            B newBlock = this.checkBlock(block);
            if (newBlock.getBlockType() == BlockTypes.__RESERVED__) {
                return false;
            }
            return super.setBlock(x, y, z, newBlock);
        }
        return super.setBlock(x, y, z, block);
    }

    private <B extends BlockStateHolder<B>> B checkBlock(B block) {
        if (this.blockedBlocks != null && this.blockedBlocks.contains(block.getBlockType().getId())) {
            return (B)(block instanceof BlockState ? RESERVED : RESERVED.toBaseBlock());
        }
        if (this.blockedStates == null) {
            return block;
        }
        for (FuzzyBlockState fuzzyBlockState : this.blockedStates) {
            if (!fuzzyBlockState.equalsFuzzy(block)) continue;
            return (B)(block instanceof BlockState ? RESERVED : RESERVED.toBaseBlock());
        }
        if (this.remaps == null || this.remaps.isEmpty()) {
            return block;
        }
        for (PropertyRemap propertyRemap : this.remaps) {
            block = propertyRemap.apply(block);
        }
        return block;
    }

    @Override
    public IChunkSet processSet(IChunk chunk, IChunkGet get, IChunkSet set) {
        if (this.blockedStates == null && this.blockedBlocks == null) {
            return set;
        }
        for (int layer = set.getMinSectionPosition(); layer <= set.getMaxSectionPosition(); ++layer) {
            if (!set.hasSection(layer)) continue;
            char[] blocks = Objects.requireNonNull(set.loadIfPresent(layer));
            block1: for (int i = 0; i < blocks.length; ++i) {
                char block = blocks[i];
                if (block == '\u0000') continue;
                BlockState state = BlockTypesCache.states[block];
                if (this.blockedBlocks != null && this.blockedBlocks.contains(state.getBlockType().getId())) {
                    blocks[i] = '\u0000';
                    continue;
                }
                if (this.blockedStates == null) continue;
                for (FuzzyBlockState fuzzyBlockState : this.blockedStates) {
                    if (!fuzzyBlockState.equalsFuzzy(state)) continue;
                    blocks[i] = '\u0000';
                    continue block1;
                }
                if (this.remaps == null || this.remaps.isEmpty()) {
                    blocks[i] = block;
                    continue;
                }
                for (PropertyRemap propertyRemap : this.remaps) {
                    state = propertyRemap.apply(state);
                }
                blocks[i] = state.getOrdinalChar();
            }
        }
        return set;
    }

    @Override
    @Nullable
    public Extent construct(Extent child) {
        if (this.getExtent() != child) {
            new ExtentTraverser<DisallowedBlocksExtent>(this).setNext((DisallowedBlocksExtent)child);
        }
        return this;
    }

    @Override
    public ProcessorScope getScope() {
        return ProcessorScope.REMOVING_BLOCKS;
    }
}

