/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extension.platform.binding;

import com.fastasyncworldedit.core.extension.platform.binding.Binding;
import com.fastasyncworldedit.core.util.StringMan;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.internal.util.LogManagerCompat;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.enginehub.piston.CommandManager;
import org.enginehub.piston.converter.ArgumentConverter;
import org.enginehub.piston.converter.ConversionResult;
import org.enginehub.piston.converter.FailedConversion;
import org.enginehub.piston.converter.SuccessfulConversion;
import org.enginehub.piston.exception.StopExecutionException;
import org.enginehub.piston.inject.InjectedValueAccess;
import org.enginehub.piston.inject.InjectedValueStore;
import org.enginehub.piston.inject.Key;

public class Bindings {
    private static final Logger LOGGER = LogManagerCompat.getLogger();
    private final WorldEdit worldEdit;

    public Bindings(WorldEdit worldEdit) {
        this.worldEdit = worldEdit;
    }

    public WorldEdit getWorldEdit() {
        return this.worldEdit;
    }

    public void register(InjectedValueStore store, CommandManager manager) {
        for (Method method : this.getClass().getDeclaredMethods()) {
            this.register(method, store, manager);
        }
    }

    private boolean register(final Method method, InjectedValueStore store, CommandManager manager) {
        Key key;
        final Binding binding = method.getAnnotation(Binding.class);
        if (binding == null) {
            return false;
        }
        Annotation[] annotations = method.getAnnotations();
        Class<?> ret = method.getReturnType();
        if (annotations.length == 1) {
            key = Key.of(ret);
        } else if (annotations.length == 2) {
            Annotation annotation = annotations[0] == binding ? annotations[1] : annotations[0];
            key = Key.of(ret, (Annotation)annotation);
        } else {
            LOGGER.error("Cannot annotate: {} with {}", (Object)method, (Object)StringMan.getString(annotations));
            return false;
        }
        Class<?>[] params = method.getParameterTypes();
        Annotation[][] paramAnns = method.getParameterAnnotations();
        final Function[] argsFunc = new Function[params.length];
        boolean provide = true;
        for (int i = 0; i < params.length; ++i) {
            Class<?> param = params[i];
            if (param != String.class) {
                Key paramKey;
                Annotation[] paramAnn = paramAnns[i];
                if (paramAnn.length == 1) {
                    paramKey = Key.of(param, (Annotation)paramAnn[0]);
                } else if (paramAnn.length == 0) {
                    paramKey = Key.of(param);
                } else {
                    throw new UnsupportedOperationException("Only one annotation is permitted for " + String.valueOf(method));
                }
                argsFunc[i] = v -> v.injectedValue(paramKey);
                continue;
            }
            if (provide) {
                provide = false;
                continue;
            }
            throw new UnsupportedOperationException("Only one argument is allowed");
        }
        if (provide) {
            store.injectValue(key, access -> Optional.of(this.invoke(null, argsFunc, (InjectedValueAccess)access, method)));
        } else {
            manager.registerConverter(key, (ArgumentConverter)new ArgumentConverter<Object>(){

                public Component describeAcceptableArguments() {
                    return TextComponent.of((String)binding.value());
                }

                public ConversionResult<Object> convert(String s, InjectedValueAccess access) {
                    try {
                        Object o = Bindings.this.invoke(s, argsFunc, access, method);
                        if (o == null) {
                            return FailedConversion.from((Throwable)new NullPointerException());
                        }
                        return SuccessfulConversion.fromSingle((Object)o);
                    }
                    catch (Throwable t) {
                        return FailedConversion.from((Throwable)t);
                    }
                }
            });
        }
        return true;
    }

    private Object invoke(String arg, Function<InjectedValueAccess, Object>[] argsFunc, InjectedValueAccess access, Method method) {
        try {
            Object[] args = new Object[argsFunc.length];
            for (int i = 0; i < argsFunc.length; ++i) {
                Function<InjectedValueAccess, Object> func = argsFunc[i];
                if (func != null) {
                    Optional optional = (Optional)func.apply(access);
                    args[i] = optional.get();
                    continue;
                }
                args[i] = arg;
            }
            return method.invoke((Object)this, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            if (!(e.getCause() instanceof StopExecutionException)) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

