/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extension.factory.parser.pattern;

import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extension.factory.parser.RichParser;
import com.fastasyncworldedit.core.function.pattern.BiomeApplyingPattern;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.util.formatting.text.Component;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class BiomePatternParser
extends RichParser<Pattern> {
    private static final String BIOME_PREFIX = "$";

    public BiomePatternParser(WorldEdit worldEdit) {
        super(worldEdit, "#biome", BIOME_PREFIX);
    }

    @Override
    public Pattern parseFromInput(String input, ParserContext context) throws InputParseException {
        if (input.startsWith(BIOME_PREFIX)) {
            String biomeId = input.substring(1);
            BiomeType biomeType = BiomeTypes.get(biomeId);
            if (biomeType == null) {
                throw new NoMatchException((Component)Caption.of("worldedit.error.unknown-biome", TextComponent.of((String)biomeId)));
            }
            return new BiomeApplyingPattern(context.requireExtent(), biomeType);
        }
        return (Pattern)super.parseFromInput(input, context);
    }

    @Override
    public Stream<String> getSuggestions(String input) {
        if (input.startsWith(BIOME_PREFIX)) {
            return BiomeType.REGISTRY.getSuggestions(input.substring(1)).map(biome -> BIOME_PREFIX + biome);
        }
        return super.getSuggestions(input);
    }

    @Override
    protected Stream<String> getSuggestions(String argumentInput, int index) {
        if (index == 0) {
            return BiomeType.REGISTRY.getSuggestions(argumentInput);
        }
        return Stream.empty();
    }

    @Override
    protected Pattern parseFromInput(@Nonnull String[] arguments, ParserContext context) throws InputParseException {
        if (arguments.length != 1) {
            throw new InputParseException((Component)Caption.of("fawe.error.invalid-arguments", TextComponent.of((String)"#biome[<biome>]")));
        }
        BiomeType biomeType = BiomeTypes.get(arguments[0]);
        if (biomeType == null) {
            throw new NoMatchException((Component)Caption.of("worldedit.error.unknown-biome", TextComponent.of((String)arguments[0])));
        }
        return new BiomeApplyingPattern(context.requireExtent(), biomeType);
    }
}

