/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.command.tool.sweep;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector2;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.math.interpolation.Interpolation;
import java.util.ArrayList;
import java.util.List;

public abstract class Spline {
    private Vector2 direction = Vector2.at(1.0, 0.0);
    private final int nodeCount;
    protected EditSession editSession;
    private final Interpolation interpolation;
    private List<Section> sections;
    private final double splineLength;

    protected Spline(EditSession editSession, Interpolation interpolation) {
        this(editSession, interpolation, -1);
    }

    protected Spline(EditSession editSession, Interpolation interpolation, int nodeCount) {
        this.editSession = editSession;
        this.interpolation = interpolation;
        this.nodeCount = nodeCount;
        this.splineLength = interpolation.arcLength(0.0, 1.0);
        if (nodeCount > 2) {
            this.initSections();
        }
    }

    public void setDirection(Vector2 direction) {
        this.direction = direction.normalize();
    }

    public Vector2 getDirection() {
        return this.direction;
    }

    public int pastePosition(double position) throws MaxChangedBlocksException {
        Preconditions.checkArgument((position >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((position <= 1.0 ? 1 : 0) != 0);
        if (this.nodeCount > 2) {
            return this.pastePositionDirect(this.translatePosition(position));
        }
        return this.pastePositionDirect(position);
    }

    private double cross2D(Vector2 v1, Vector2 v2) {
        return v1.getX() * v2.getZ() - v2.getX() * v1.getZ();
    }

    public int pastePositionDirect(double position) throws MaxChangedBlocksException {
        Preconditions.checkArgument((position >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkArgument((position <= 1.0 ? 1 : 0) != 0);
        Vector3 target = this.interpolation.getPosition(position);
        BlockVector3 blockTarget = target.toBlockPoint();
        Vector3 offset = target.subtract(target.floor());
        Vector3 deriv = this.interpolation.get1stDerivative(position);
        Vector2 deriv2D = Vector2.at(deriv.getX(), deriv.getZ()).normalize();
        double angle = Math.toDegrees(-Math.atan2(this.cross2D(this.direction, deriv2D), this.direction.dot(deriv2D)));
        angle = (angle % 360.0 + 360.0) % 360.0;
        return this.pasteBlocks(blockTarget, offset, angle);
    }

    protected abstract int pasteBlocks(BlockVector3 var1, Vector3 var2, double var3) throws MaxChangedBlocksException;

    private void initSections() {
        int sectionCount = this.nodeCount - 1;
        this.sections = new ArrayList<Section>(sectionCount);
        double sectionLength = 1.0 / (double)sectionCount;
        double position = 0.0;
        for (int i = 0; i < sectionCount; ++i) {
            double length = i == sectionCount - 1 ? this.interpolation.arcLength((double)i * sectionLength, 1.0) / this.splineLength : this.interpolation.arcLength((double)i * sectionLength, (double)(i + 1) * sectionLength) / this.splineLength;
            this.sections.add(new Section((double)i * sectionLength, sectionLength, position, length));
            position += length;
        }
    }

    private double translatePosition(double flexPosition) {
        double flexOffset;
        double uniOffset;
        double finalPosition;
        Section previousSection = this.sections.get(0);
        for (int i = 1; i < this.sections.size(); ++i) {
            Section section = this.sections.get(i);
            if (flexPosition < section.flexStart) break;
            previousSection = section;
        }
        if ((finalPosition = previousSection.uniStart + (uniOffset = (flexOffset = flexPosition - previousSection.flexStart) / previousSection.flexLength * previousSection.uniLength)) > 1.0) {
            return 1.0;
        }
        return finalPosition;
    }

    private record Section(double uniStart, double uniLength, double flexStart, double flexLength) {
    }
}

