/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.command.tool.brush;

import com.fastasyncworldedit.core.FaweCache;
import com.fastasyncworldedit.core.command.tool.brush.ScatterBrush;
import com.fastasyncworldedit.core.math.LocalBlockVectorSet;
import com.fastasyncworldedit.core.util.StringMan;
import com.fastasyncworldedit.core.wrappers.AsyncPlayer;
import com.fastasyncworldedit.core.wrappers.LocationMaskedPlayerWrapper;
import com.fastasyncworldedit.core.wrappers.SilentPlayerWrapper;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.PlatformCommandManager;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.util.Location;
import java.util.List;

public class ScatterCommand
extends ScatterBrush {
    private final String command;
    private final boolean print;

    public ScatterCommand(int count, int distance, String command, boolean print) {
        super(count, distance);
        this.command = command;
        this.print = print;
    }

    @Override
    public void apply(EditSession editSession, LocalBlockVectorSet placed, BlockVector3 position, Pattern pattern, double size) throws MaxChangedBlocksException {
        int radius = this.getDistance();
        CuboidRegionSelector selector = new CuboidRegionSelector(editSession.getWorld(), position.subtract(radius, radius, radius), position.add(radius, radius, radius));
        String replaced = this.command.replace("{x}", Integer.toString(position.getBlockX())).replace("{y}", Integer.toString(position.getBlockY())).replace("{z}", Integer.toString(position.getBlockZ())).replace("{world}", editSession.getWorld().getName()).replace("{size}", Integer.toString(radius));
        Actor actor = editSession.getActor();
        if (!(actor instanceof Player)) {
            throw FaweCache.PLAYER_ONLY;
        }
        Player player = (Player)actor;
        player.setSelection(selector);
        List<String> cmds = StringMan.split(replaced, ';');
        AsyncPlayer wePlayer = new LocationMaskedPlayerWrapper(player, new Location(player.getExtent(), position.toVector3()));
        if (!this.print) {
            wePlayer = new SilentPlayerWrapper(wePlayer);
        }
        for (String string : cmds) {
            if (string.isBlank()) continue;
            Object object2 = string.charAt(0) != '/' ? "/" + string : string;
            object2 = ((String)object2).length() > 1 && ((String)object2).charAt(1) == '/' ? ((String)object2).substring(1) : object2;
            CommandEvent event = new CommandEvent(wePlayer, (String)object2, editSession);
            PlatformCommandManager.getInstance().handleCommandOnCurrentThread(event);
        }
    }
}

