/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.command.tool.brush;

import com.fastasyncworldedit.core.extent.clipboard.CPUOptimizedClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;

public class ErodeBrush
implements Brush {
    private static final BlockVector3[] FACES_TO_CHECK = (BlockVector3[])Direction.valuesOf(Direction.Flag.CARDINAL).stream().map(Direction::toBlockVector).toArray(BlockVector3[]::new);
    private final int erodeFaces;
    private final int erodeRecursion;
    private final int fillFaces;
    private final int fillRecursion;

    public ErodeBrush() {
        this(2, 1, 5, 1);
    }

    public ErodeBrush(int erodeFaces, int erodeRecursion, int fillFaces, int fillRecursion) {
        this.erodeFaces = erodeFaces;
        this.erodeRecursion = erodeRecursion;
        this.fillFaces = fillFaces;
        this.fillRecursion = fillRecursion;
    }

    @Override
    public void build(EditSession editSession, BlockVector3 position, Pattern pattern, double size) throws MaxChangedBlocksException {
        this.erosion(editSession, this.erodeFaces, this.erodeRecursion, this.fillFaces, this.fillRecursion, position, size);
    }

    public void erosion(EditSession es, int erodeFaces, int erodeRecursion, int fillFaces, int fillRecursion, BlockVector3 target, double size) {
        int i;
        int brushSize = (int)size;
        int brushSizeSquared = (int)(size * size);
        Location min = new Location(es.getWorld(), target.toVector3().subtract(size, size, size));
        Location max = new Location(es.getWorld(), target.toVector3().add(size, size, size));
        CuboidRegion region = new CuboidRegion(es.getWorld(), min.toBlockPoint(), max.toBlockPoint());
        CPUOptimizedClipboard buffer1 = new CPUOptimizedClipboard(region);
        CPUOptimizedClipboard buffer2 = new CPUOptimizedClipboard(region);
        int bx = target.getBlockX();
        int by = target.getBlockY();
        int bz = target.getBlockZ();
        int x = -brushSize;
        for (int relx = 0; x <= brushSize && relx < buffer1.getWidth(); ++x, ++relx) {
            int x0 = x + bx;
            int y = -brushSize;
            for (int rely = 0; y <= brushSize && rely < buffer1.getHeight(); ++y, ++rely) {
                int y0 = y + by;
                int z = -brushSize;
                for (int relz = 0; z <= brushSize && relz < buffer1.getLength(); ++z, ++relz) {
                    int z0 = z + bz;
                    BlockState state = es.getBlock(x0, y0, z0);
                    buffer1.setBlock(relx, rely, relz, state);
                    buffer2.setBlock(relx, rely, relz, state);
                }
            }
        }
        int swap = 0;
        for (i = 0; i < erodeRecursion; ++i) {
            this.erosionIteration(brushSize, brushSizeSquared, erodeFaces, swap % 2 == 0 ? buffer1 : buffer2, swap % 2 == 1 ? buffer1 : buffer2);
            ++swap;
        }
        for (i = 0; i < fillRecursion; ++i) {
            this.fillIteration(brushSize, brushSizeSquared, fillFaces, swap % 2 == 0 ? buffer1 : buffer2, swap % 2 == 1 ? buffer1 : buffer2);
            ++swap;
        }
        CPUOptimizedClipboard finalBuffer = swap % 2 == 0 ? buffer1 : buffer2;
        for (BlockVector3 pos : finalBuffer) {
            BlockState block = pos.getBlock(finalBuffer);
            es.setBlock(pos.getX() + bx - brushSize, pos.getY() + by - brushSize, pos.getZ() + bz - brushSize, block);
        }
    }

    private void fillIteration(int brushSize, int brushSizeSquared, int fillFaces, Clipboard current, Clipboard target) {
        int[] frequency = null;
        int x = -brushSize;
        for (int relx = 0; x <= brushSize && relx < target.getWidth(); ++x, ++relx) {
            int x2 = x * x;
            int z = -brushSize;
            for (int relz = 0; z <= brushSize && relz < target.getLength(); ++z, ++relz) {
                int x2y2 = x2 + z * z;
                int y = -brushSize;
                for (int rely = 0; y <= brushSize && rely < target.getHeight(); ++y, ++rely) {
                    BaseBlock state;
                    int cube = x2y2 + y * y;
                    target.setBlock(relx, rely, relz, current.getBlock(relx, rely, relz));
                    if (cube >= brushSizeSquared || (state = current.getFullBlock(relx, rely, relz)).getBlockType().getMaterial().isMovementBlocker()) continue;
                    BaseBlock highestState = state;
                    if (frequency == null) {
                        frequency = new int[BlockTypes.size()];
                    } else {
                        Arrays.fill(frequency, 0);
                    }
                    int total = 0;
                    int highest = 1;
                    for (BlockVector3 offs : FACES_TO_CHECK) {
                        BaseBlock next = current.getFullBlock(relx + offs.getBlockX(), rely + offs.getBlockY(), relz + offs.getBlockZ());
                        if (!next.getBlockType().getMaterial().isMovementBlocker()) continue;
                        ++total;
                        int n = next.getInternalBlockTypeId();
                        frequency[n] = frequency[n] + 1;
                        int count = frequency[n];
                        if (count < highest) continue;
                        highest = count;
                        highestState = next;
                    }
                    if (total < fillFaces) continue;
                    target.setBlock(relx, rely, relz, highestState);
                }
            }
        }
    }

    private void erosionIteration(int brushSize, int brushSizeSquared, int erodeFaces, Clipboard current, Clipboard target) {
        int[] frequency = null;
        int x = -brushSize;
        for (int relx = 0; x <= brushSize && relx < target.getWidth(); ++x, ++relx) {
            int x2 = x * x;
            int z = -brushSize;
            for (int relz = 0; z <= brushSize && relz < target.getLength(); ++z, ++relz) {
                int x2y2 = x2 + z * z;
                int y = -brushSize;
                for (int rely = 0; y <= brushSize && rely < target.getHeight(); ++y, ++rely) {
                    BaseBlock state;
                    int cube = x2y2 + y * y;
                    target.setBlock(relx, rely, relz, current.getBlock(relx, rely, relz));
                    if (cube >= brushSizeSquared || !(state = current.getFullBlock(relx, rely, relz)).getMaterial().isMovementBlocker()) continue;
                    BaseBlock highestState = state;
                    if (frequency == null) {
                        frequency = new int[BlockTypes.size()];
                    } else {
                        Arrays.fill(frequency, 0);
                    }
                    int highest = 1;
                    int total = 0;
                    for (BlockVector3 offs : FACES_TO_CHECK) {
                        BaseBlock next = current.getFullBlock(relx + offs.getBlockX(), rely + offs.getBlockY(), relz + offs.getBlockZ());
                        if (next.getMaterial().isMovementBlocker()) continue;
                        ++total;
                        int n = next.getInternalBlockTypeId();
                        frequency[n] = frequency[n] + 1;
                        int count = frequency[n];
                        if (count <= highest) continue;
                        highest = count;
                        highestState = next;
                    }
                    if (total < erodeFaces) continue;
                    target.setBlock(relx, rely, relz, highestState);
                }
            }
        }
    }
}

