/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.command.tool.brush;

import com.fastasyncworldedit.core.function.mask.CachedMask;
import com.fastasyncworldedit.core.math.MutableBlockVector3;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Arrays;
import javax.annotation.Nullable;

public class BlendBall
implements Brush {
    private static final BlockState AIR = BlockTypes.AIR.getDefaultState();
    private final int minFreqDiff;
    private final boolean onlyAir;
    @Nullable
    private final CachedMask mask;

    public BlendBall() {
        this(1, false, null);
    }

    public BlendBall(int minFreqDiff, boolean onlyAir, @Nullable CachedMask mask) {
        this.minFreqDiff = minFreqDiff;
        this.onlyAir = onlyAir;
        this.mask = mask;
    }

    @Override
    public void build(EditSession editSession, BlockVector3 position, Pattern pattern, double size) throws MaxChangedBlocksException {
        int outsetSize = (int)(size + 1.0);
        double brushSizeSquared = size * size;
        int tx = position.getBlockX();
        int ty = position.getBlockY();
        int tz = position.getBlockZ();
        int[] frequency = new int[BlockTypes.size()];
        int maxY = editSession.getMaxY();
        int minY = editSession.getMinY();
        MutableBlockVector3 mutable = new MutableBlockVector3();
        for (int x = -outsetSize; x <= outsetSize; ++x) {
            int x0 = x + tx;
            int xx = x * x;
            for (int y = -outsetSize; y <= outsetSize; ++y) {
                int yy;
                int xxyy;
                int y0 = y + ty;
                if (y0 + 1 < minY || y0 - 1 > maxY || (double)(xxyy = xx + (yy = y * y)) >= brushSizeSquared) continue;
                for (int z = -outsetSize; z <= outsetSize; ++z) {
                    BlockState currentState;
                    int z0 = z + tz;
                    if ((double)(xxyy + z * z) >= brushSizeSquared || this.maskFails(editSession, mutable.setComponents(x0, y0, z0))) continue;
                    int highest = 1;
                    int currentBlockFrequency = 1;
                    BlockState highestState = currentState = editSession.getBlock(x0, y0, z0);
                    int currentStateID = currentState.getInternalBlockTypeId();
                    Arrays.fill(frequency, 0);
                    int air = 0;
                    int total = 26;
                    boolean tie = false;
                    for (int ox = -1; ox <= 1; ++ox) {
                        for (int oz = -1; oz <= 1; ++oz) {
                            for (int oy = -1; oy <= 1; ++oy) {
                                BlockState state;
                                if (ox == 0 && oy == 0 && oz == 0) continue;
                                if (oy + y0 < minY || oy + y0 > maxY) {
                                    --total;
                                    continue;
                                }
                                boolean masked = this.maskFails(editSession, mutable.setComponents(x0 + ox, y0 + oy, z0 + oz));
                                BlockState blockState = state = masked ? AIR : editSession.getBlock(x0 + ox, y0 + oy, z0 + oz);
                                if (state.getBlockType().getMaterial().isAir()) {
                                    ++air;
                                }
                                int internalID = state.getInternalBlockTypeId();
                                int count = frequency[internalID];
                                if (internalID == currentStateID) {
                                    ++currentBlockFrequency;
                                }
                                if (++count - highest >= this.minFreqDiff) {
                                    highest = count;
                                    highestState = state;
                                    tie = false;
                                } else if (count == highest) {
                                    tie = true;
                                }
                                frequency[internalID] = count;
                            }
                        }
                    }
                    if (this.onlyAir) {
                        if (air * 2 - total >= this.minFreqDiff) {
                            if (currentState.isAir()) continue;
                            editSession.setBlock(x0, y0, z0, AIR);
                            continue;
                        }
                        if (!currentState.isAir() || total - 2 * air < this.minFreqDiff) continue;
                        editSession.setBlock(x0, y0, z0, highestState);
                        continue;
                    }
                    if (highest - currentBlockFrequency < this.minFreqDiff || tie || currentState == highestState) continue;
                    editSession.setBlock(x0, y0, z0, highestState);
                }
            }
        }
    }

    private boolean maskFails(EditSession editSession, MutableBlockVector3 mutable) {
        return this.mask != null && !this.mask.test(editSession, mutable);
    }
}

