/*
 * Decompiled with CFR 0.152.
 */
package org.purpurmc.purpur.event.entity;

import com.google.common.base.Preconditions;
import org.bukkit.Location;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.NotNull;

public class RidableMoveEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private boolean canceled;
    private final Player rider;
    private Location from;
    private Location to;

    public RidableMoveEvent(@NotNull Mob entity, @NotNull Player rider, @NotNull Location from, @NotNull Location to) {
        super(entity);
        this.rider = rider;
        this.from = from;
        this.to = to;
    }

    @Override
    @NotNull
    public Mob getEntity() {
        return (Mob)this.entity;
    }

    @NotNull
    public Player getRider() {
        return this.rider;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.canceled = cancel;
    }

    @NotNull
    public Location getFrom() {
        return this.from;
    }

    public void setFrom(@NotNull Location from) {
        this.validateLocation(from);
        this.from = from;
    }

    @NotNull
    public Location getTo() {
        return this.to;
    }

    public void setTo(@NotNull Location to) {
        this.validateLocation(to);
        this.to = to;
    }

    private void validateLocation(@NotNull Location loc) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"Cannot use null location!");
        Preconditions.checkArgument((loc.getWorld() != null ? 1 : 0) != 0, (Object)"Cannot use null location with null world!");
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

