/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.util;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class RomanNumerals {
    private static final Map<Character, Integer> CHAR_TO_NUMBER = Arrays.stream(RomanNumber.values()).filter(num -> num.name().length() == 1).collect(Collectors.toMap(num -> Character.valueOf(num.name().charAt(0)), RomanNumber::getValue));

    public static String toNumerals(int value) {
        Validate.isTrue((value > 0 ? 1 : 0) != 0, (String)"Roman numbers can't express zero or negative numbers", (Object[])new Object[0]);
        StringBuilder builder = new StringBuilder();
        for (RomanNumber romanNumber : RomanNumber.values()) {
            while (value >= romanNumber.getValue()) {
                value -= romanNumber.getValue();
                builder.append(romanNumber.name());
            }
        }
        return builder.toString();
    }

    public static int fromNumerals(String romanNumeral) {
        if (romanNumeral == null || romanNumeral.isEmpty()) {
            return 0;
        }
        int result = 0;
        int next = RomanNumerals.getNumeralValue(romanNumeral.charAt(0));
        for (int i = 1; i < romanNumeral.length(); ++i) {
            int value = next;
            next = RomanNumerals.getNumeralValue(romanNumeral.charAt(i));
            if (next == 0) {
                return 0;
            }
            result += next > value ? -value : value;
        }
        return result + next;
    }

    private static int getNumeralValue(char numeral) {
        return CHAR_TO_NUMBER.getOrDefault(Character.valueOf(numeral), 0);
    }

    private static enum RomanNumber {
        M(1000),
        CM(900),
        D(500),
        CD(400),
        C(100),
        XC(90),
        L(50),
        XL(40),
        X(10),
        IX(9),
        V(5),
        IV(4),
        I(1);

        private final int value;

        private RomanNumber(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

