/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.util;

import io.lumine.mythic.bukkit.utils.text.Text;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.util.RomanNumerals;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class LoreParser {
    private LoreParser() {
    }

    public static String formatEnchantment(MythicEnchant enchantment, int level) {
        String levelString;
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment lore parser initiated", (Object[])new Object[0]);
        Object enchantmentName = Text.replaceLegacy((String)enchantment.getDisplayName());
        String string = levelString = level > 0 && enchantment.getMaxLevel() > 1 ? " " + RomanNumerals.toNumerals(level) : "";
        if (!LoreParser.isComponentWithColor(MiniMessage.miniMessage().deserialize(enchantmentName))) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Enchantment name: {0} is not deserializable!", (Object[])new Object[]{enchantmentName});
            return "<gray>" + (String)enchantmentName + levelString;
        }
        if (((String)enchantmentName).lastIndexOf(">") == ((String)enchantmentName).length() - 1) {
            int lastTagIndex = ((String)enchantmentName).lastIndexOf("<");
            enchantmentName = ((String)enchantmentName).substring(0, lastTagIndex) + levelString + ((String)enchantmentName).substring(lastTagIndex);
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Last Tag method used for {0}", (Object[])new Object[]{enchantmentName});
        } else {
            enchantmentName = (String)enchantmentName + levelString;
        }
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Enchantment name: " + (String)enchantmentName), (Object[])new Object[0]);
        return enchantmentName;
    }

    private static boolean isComponentWithColor(Component component) {
        if (component.color() != null) {
            return true;
        }
        for (Component child : component.children()) {
            if (!LoreParser.isComponentWithColor(child)) continue;
            return true;
        }
        return false;
    }
}

