/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.profiles;

import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.storage.players.PlayerRepository;
import io.lumine.mythic.bukkit.utils.storage.players.PlayerStorageAdapter;
import io.lumine.mythic.bukkit.utils.storage.players.adapters.file.JsonPlayerStorageAdapter;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import java.util.UUID;
import org.bukkit.entity.Player;

public class EnchantsProfileManager
extends PlayerRepository<MythicEnchants, EnchantsProfile> {
    public EnchantsProfileManager(MythicEnchants plugin) {
        super((LuminePlugin)plugin, EnchantsProfile.class, (PlayerStorageAdapter)new JsonPlayerStorageAdapter((LuminePlugin)plugin, EnchantsProfile.class));
    }

    public EnchantsProfile createProfile(UUID id, String name, int subProfileOffset) {
        return new EnchantsProfile(id, name);
    }

    public void initProfile(EnchantsProfile profile, Player player) {
        profile.initialize(this, player);
        profile.parseEquipment();
    }

    public void unloadProfile(EnchantsProfile profile, Player player) {
    }

    public void updatePlayerArmor(Player player) {
        EnchantsProfile profile = (EnchantsProfile)this.getProfile(player);
        if (profile != null) {
            profile.parseEquipment();
        }
    }

    public void updatePlayerArmorDelayed(Player player) {
        Schedulers.sync().runLater(() -> this.updatePlayerArmor(player), 1L);
    }

    private void clearPlayerWeapon(Player player) {
        ((EnchantsProfile)this.getProfile(player)).clearWeapon();
    }

    public void clearPlayerWeaponDelayed(Player player) {
        Schedulers.sync().runLater(() -> this.clearPlayerWeapon(player), 1L);
    }

    public void updatePlayerWeapon(Player player) {
        ((EnchantsProfile)this.getProfile(player)).parseWeapons();
    }

    public void updatePlayerWeaponDelayed(Player player) {
        Schedulers.sync().runLater(() -> this.updatePlayerWeapon(player), 1L);
    }

    public void runTimerSkills(long timer) {
        this.getKnownProfiles().stream().forEach(profile -> {
            Player player = profile.getPlayer();
            if (profile.hasTimerSkills()) {
                profile.runTimerSkills(BukkitAdapter.adapt((Player)player), timer);
            }
        });
    }
}

