/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.profiles;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.storage.players.Profile;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.players.PlayerData;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.custom.CustomEnchantment;
import io.lumine.mythicenchants.enchants.properties.EnchantSlot;
import io.lumine.mythicenchants.enchants.properties.EnchantType;
import io.lumine.mythicenchants.enchants.skills.AppliedEnchant;
import io.lumine.mythicenchants.enchants.skills.SkillHolder;
import io.lumine.mythicenchants.profiles.EnchantsProfileManager;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;

public class EnchantsProfile
implements Profile {
    private transient EnchantsProfileManager manager;
    private UUID uniqueId;
    private String name;
    private long timestamp = System.currentTimeMillis();
    private transient Player player;
    private transient PlayerData playerData;
    private transient Map<EnchantSlot, ItemStack> equipment = new EnumMap<EnchantSlot, ItemStack>(EnchantSlot.class);
    private transient Map<EnchantSlot, List<AppliedEnchant>> equippedEnchantments = new EnumMap<EnchantSlot, List<AppliedEnchant>>(EnchantSlot.class);
    private transient Map<EnchantSlot, List<AppliedEnchant>> equippedStatEnchantments = new EnumMap<EnchantSlot, List<AppliedEnchant>>(EnchantSlot.class);
    private final transient List<SkillHolder> heldEnchantSkills = Lists.newArrayList();
    private final transient List<SkillHolder> equippedSkills = Lists.newArrayList();
    private transient boolean hasArmorTimerSkills = true;
    private transient boolean hasHeldTimerSkills = true;
    private transient ConcurrentHashMap<EnchantType, Long> cooldownMap = new ConcurrentHashMap();

    public EnchantsProfile() {
    }

    public EnchantsProfile(UUID id, String name) {
        this.uniqueId = id;
        this.name = name;
    }

    public void initialize(EnchantsProfileManager manager, Player player) {
        this.manager = manager;
        this.player = player;
        ((MythicEnchants)manager.getPlugin()).core().getPlayerManager().awaitProfile(player).thenAcceptSync(maybeProfile -> {
            if (maybeProfile.isPresent()) {
                this.playerData = (PlayerData)maybeProfile.get();
                this.parseEquipment();
            }
        });
    }

    public boolean isValid() {
        return this.playerData != null;
    }

    public void parseEquipment() {
        if (!this.isValid()) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"CrucibleProfile not loaded yet for {0}", (Object[])new Object[]{this.player.getName()});
            return;
        }
        this.equippedSkills.clear();
        this.hasArmorTimerSkills = false;
        EntityEquipment ee = this.player.getEquipment();
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.EVENT, (String)"Parsing equipment for {0}", (Object[])new Object[]{this.player.getName()});
        this.parseArmorItemSkills(EnchantSlot.HEAD);
        this.parseArmorItemSkills(EnchantSlot.CHEST);
        this.parseArmorItemSkills(EnchantSlot.LEGS);
        this.parseArmorItemSkills(EnchantSlot.FEET);
        this.parseArmorItemSkills(EnchantSlot.OFFHAND);
        this.parseWeapons(false);
        this.playerData.getStatRegistry().updateDirtyStats();
    }

    private void parseArmorItemSkills(EnchantSlot slot) {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.EVENT, (String)"Parsing Armor Slot {0} for {1}", (Object[])new Object[]{slot.name(), this.player.getName()});
        this.clearSlotEnchantStats(slot);
        Optional<ItemStack> maybeItem = slot.getItem(this.player);
        if (!maybeItem.isPresent()) {
            return;
        }
        ItemStack item = maybeItem.get();
        if (item != null && item.hasItemMeta() && item.getType() != Material.ENCHANTED_BOOK) {
            for (Map.Entry entry : item.getEnchantments().entrySet()) {
                CustomEnchantment cEnchant;
                MythicEnchant mythicEnchant;
                Enchantment enchant = (Enchantment)entry.getKey();
                Optional<MythicEnchant> maybeMythicEnchant = ((MythicEnchants)this.manager.getPlugin()).getEnchantManager().toMythicEnchantment(enchant);
                if (!maybeMythicEnchant.isPresent() || !((mythicEnchant = maybeMythicEnchant.get()) instanceof CustomEnchantment) || !(cEnchant = (CustomEnchantment)mythicEnchant).getApplicableSlots().isEmpty() && !cEnchant.getApplicableSlots().contains((Object)slot)) continue;
                if (cEnchant.hasTimerSkills()) {
                    this.hasArmorTimerSkills = true;
                }
                AppliedEnchant appliedEnchant = new AppliedEnchant(this, cEnchant, (Integer)entry.getValue(), slot, item.getType());
                this.equippedSkills.add(appliedEnchant);
                if (appliedEnchant.getStats().isEmpty()) continue;
                this.equippedStatEnchantments.compute(slot, (s, v) -> Lists.newArrayList()).add(appliedEnchant);
            }
        }
    }

    public void clearSlotEnchantStats(EnchantSlot slot) {
        List<AppliedEnchant> list = this.equippedStatEnchantments.remove((Object)slot);
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.EVENT, (String)"Clearing Slot Enchant Stats for {0} of {1}", (Object[])new Object[]{slot.name(), this.player.getName()});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.EVENT, (String)"Cleared {0} enchants", (Object[])new Object[]{list == null ? "0" : Integer.valueOf(list.size())});
        if (list == null) {
            return;
        }
        for (AppliedEnchant enchant : list) {
            for (StatType statType : enchant.getStats()) {
                this.playerData.getStatRegistry().removeValueSilently(statType, (StatSource)enchant);
            }
        }
    }

    public void clearWeapon() {
        this.equippedEnchantments.remove((Object)EnchantSlot.HAND);
        this.heldEnchantSkills.clear();
        this.clearSlotEnchantStats(EnchantSlot.HAND);
    }

    public void parseWeapons() {
        this.parseWeapons(true);
    }

    public void parseWeapons(boolean update) {
        this.heldEnchantSkills.clear();
        this.equippedEnchantments.remove((Object)EnchantSlot.HAND);
        this.hasHeldTimerSkills = false;
        this.clearSlotEnchantStats(EnchantSlot.HAND);
        ItemStack item = this.player.getInventory().getItemInMainHand();
        if (item.getType() != Material.ENCHANTED_BOOK) {
            for (Map.Entry entry : item.getEnchantments().entrySet()) {
                CustomEnchantment cEnchant;
                MythicEnchant mythicEnchant;
                Enchantment enchant = (Enchantment)entry.getKey();
                Optional<MythicEnchant> maybeMythicEnchant = ((MythicEnchants)this.manager.getPlugin()).getEnchantManager().toMythicEnchantment(enchant);
                if (!maybeMythicEnchant.isPresent() || !((mythicEnchant = maybeMythicEnchant.get()) instanceof CustomEnchantment) || !(cEnchant = (CustomEnchantment)mythicEnchant).getApplicableSlots().isEmpty() && !cEnchant.getApplicableSlots().contains((Object)EnchantSlot.HAND)) continue;
                if (cEnchant.hasTimerSkills()) {
                    this.hasHeldTimerSkills = true;
                }
                AppliedEnchant appliedEnchant = new AppliedEnchant(this, cEnchant, (Integer)entry.getValue(), EnchantSlot.HAND, item.getType());
                this.heldEnchantSkills.add(appliedEnchant);
                this.equippedEnchantments.compute(EnchantSlot.HAND, (s, v) -> Lists.newArrayList()).add(appliedEnchant);
                if (appliedEnchant.getStats().isEmpty()) continue;
                this.equippedStatEnchantments.compute(EnchantSlot.HAND, (s, v) -> Lists.newArrayList()).add(appliedEnchant);
            }
        }
        if (update) {
            this.playerData.getStatRegistry().updateDirtyStats();
        }
    }

    public boolean runSkills(SkillTrigger cause, AbstractEntity trigger) {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Running skills for {0} with trigger {1}", (Object[])new Object[]{this.player.getName(), cause.name()});
        return this.runSkills(cause, null, trigger, null);
    }

    public boolean runSkills(SkillTrigger cause, AbstractLocation origin, AbstractEntity trigger) {
        return this.runSkills(cause, origin, trigger, null);
    }

    public boolean runSkills(SkillTrigger cause, AbstractLocation origin, AbstractEntity trigger, Consumer<SkillMetadata> transformer) {
        boolean cancel = false;
        for (SkillHolder holder : this.heldEnchantSkills) {
            if (!holder.runSkills((SkillCaster)this.playerData, cause, origin, trigger, transformer)) continue;
            cancel = true;
        }
        for (SkillHolder holder : this.equippedSkills) {
            if (!holder.runSkills((SkillCaster)this.playerData, cause, origin, trigger, transformer)) continue;
            cancel = true;
        }
        return cancel;
    }

    public void runSkills(IParentSkill parent, SkillMetadata data) {
        for (SkillHolder holder : this.heldEnchantSkills) {
            holder.runSkills(parent, data);
        }
        for (SkillHolder holder : this.equippedSkills) {
            holder.runSkills(parent, data);
        }
    }

    public boolean hasTimerSkills() {
        return this.hasArmorTimerSkills || this.hasHeldTimerSkills;
    }

    public void runTimerSkills(AbstractPlayer caster, long timer) {
        if (!caster.isOnline()) {
            return;
        }
        this.heldEnchantSkills.forEach(holder -> {
            if (holder.hasTimerSkills()) {
                Schedulers.async().run(() -> holder.runTimerSkills((SkillCaster)this.playerData, timer));
            }
        });
        this.equippedSkills.forEach(holder -> {
            if (holder.hasTimerSkills()) {
                Schedulers.async().run(() -> holder.runTimerSkills((SkillCaster)this.playerData, timer));
            }
        });
    }

    public boolean isEnchantInCooldownMap(EnchantType enchantType) {
        return this.cooldownMap.containsKey((Object)enchantType);
    }

    public boolean isEnchantOnCooldown(EnchantType enchantType, Double duration) {
        long durationInMillis = (long)(duration * 1000.0);
        return System.currentTimeMillis() - this.cooldownMap.get((Object)enchantType) <= durationInMillis;
    }

    public void setOnCooldown(EnchantType enchantType) {
        this.cooldownMap.put(enchantType, System.currentTimeMillis());
    }

    public Double getRemainingCooldown(EnchantType enchantType, Double duration) {
        return duration - ((double)System.currentTimeMillis() - (double)this.getCooldownMap().get((Object)enchantType).longValue()) / 1000.0;
    }

    public AbstractLocation getLocation() {
        return BukkitAdapter.adapt((Location)this.player.getLocation());
    }

    public AbstractEntity getEntity() {
        return BukkitAdapter.adapt((Player)this.player);
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Player getPlayer() {
        return this.player;
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public Map<EnchantSlot, ItemStack> getEquipment() {
        return this.equipment;
    }

    public Map<EnchantSlot, List<AppliedEnchant>> getEquippedEnchantments() {
        return this.equippedEnchantments;
    }

    public Map<EnchantSlot, List<AppliedEnchant>> getEquippedStatEnchantments() {
        return this.equippedStatEnchantments;
    }

    public ConcurrentHashMap<EnchantType, Long> getCooldownMap() {
        return this.cooldownMap;
    }

    public void setCooldownMap(ConcurrentHashMap<EnchantType, Long> cooldownMap) {
        this.cooldownMap = cooldownMap;
    }
}

