/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.stations;

import com.google.common.collect.Maps;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.numbers.Numbers;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.stations.AbstractEnchantmentStationHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.PrepareGrindstoneEvent;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GrindstoneHandler
extends AbstractEnchantmentStationHandler {
    public GrindstoneHandler(MythicEnchants mythicEnchants, EnchantManager enchantManager) {
        super(mythicEnchants, enchantManager);
    }

    private void handleGrindstoneOutput(Inventory eventInventory) {
        MythicEnchant mythicEnchant;
        Optional<MythicEnchant> maybeMythicEnchant;
        Enchantment enchant;
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Grindstone Input Clicked", (Object[])new Object[0]);
        GrindstoneInventory inventory = (GrindstoneInventory)eventInventory;
        ItemStack upperGrindstoneItem = inventory.getUpperItem();
        ItemStack lowerGrindstoneItem = inventory.getLowerItem();
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Upper Item: " + String.valueOf(upperGrindstoneItem)), (Object[])new Object[0]);
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Lower Item: " + String.valueOf(lowerGrindstoneItem)), (Object[])new Object[0]);
        ItemStack output = inventory.getResult();
        if (!GrindstoneHandler.itemStackPresent(upperGrindstoneItem) && !GrindstoneHandler.itemStackPresent(lowerGrindstoneItem)) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"No items in Grindstone", (Object[])new Object[0]);
            return;
        }
        HashMap remove = Maps.newHashMap();
        HashMap keep = Maps.newHashMap();
        if (upperGrindstoneItem != null) {
            for (Map.Entry entry : upperGrindstoneItem.getEnchantments().entrySet()) {
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Enchantment: " + String.valueOf(entry.getKey()) + " Level: " + String.valueOf(entry.getValue())), (Object[])new Object[0]);
                enchant = (Enchantment)entry.getKey();
                maybeMythicEnchant = ((MythicEnchants)this.getPlugin()).getEnchantManager().toMythicEnchantment(enchant);
                if (!maybeMythicEnchant.isPresent()) continue;
                mythicEnchant = maybeMythicEnchant.get();
                if (mythicEnchant.isCursed()) {
                    remove.put(mythicEnchant, (Integer)entry.getValue());
                    keep.put(mythicEnchant, (Integer)entry.getValue());
                    continue;
                }
                remove.put(mythicEnchant, (Integer)entry.getValue());
            }
        }
        if (lowerGrindstoneItem != null) {
            for (Map.Entry entry : lowerGrindstoneItem.getEnchantments().entrySet()) {
                enchant = (Enchantment)entry.getKey();
                maybeMythicEnchant = ((MythicEnchants)this.getPlugin()).getEnchantManager().toMythicEnchantment(enchant);
                if (!maybeMythicEnchant.isPresent()) continue;
                mythicEnchant = maybeMythicEnchant.get();
                if (mythicEnchant.isCursed()) {
                    remove.put(mythicEnchant, (Integer)entry.getValue());
                    keep.merge(mythicEnchant, (Integer)entry.getValue(), (v1, v2) -> Numbers.max((int)v1, (int)v2));
                    continue;
                }
                remove.put(mythicEnchant, (Integer)entry.getValue());
            }
        }
        if (keep.isEmpty() && remove.isEmpty()) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"No Enchantments to remove", (Object[])new Object[0]);
            return;
        }
        for (Map.Entry removeEnchant : remove.entrySet()) {
            this.enchantManager.removeEnchantment(output, (MythicEnchant)removeEnchant.getKey(), (Integer)removeEnchant.getValue());
        }
        for (Map.Entry entry : keep.entrySet()) {
            this.enchantManager.applyToItem(output, (MythicEnchant)entry.getKey(), (Integer)entry.getValue());
        }
        inventory.setItem(2, output);
    }

    @Override
    protected void subscribeHandlerEvents() {
        Log.info((String)"Subscribing to Grindstone Events");
        Events.subscribe(PrepareGrindstoneEvent.class).handler(event -> Schedulers.sync().runLater(() -> this.handleGrindstoneOutput((Inventory)event.getInventory()), 1L)).bindWith((TerminableConsumer)this);
    }
}

