/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.stations;

import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.stations.AbstractEnchantmentStationHandler;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.ItemStack;

public class AnvilHandler
extends AbstractEnchantmentStationHandler {
    public AnvilHandler(MythicEnchants plugin, EnchantManager enchantManager) {
        super(plugin, enchantManager);
    }

    @Override
    protected void subscribeHandlerEvents() {
        Log.info((String)"Subscribing to Anvil Events");
        Events.subscribe(PrepareAnvilEvent.class).handler(this::handleAnvilEvent).bindWith((TerminableConsumer)this);
    }

    private void handleAnvilEvent(PrepareAnvilEvent anvilEvent) {
        ItemStack first = anvilEvent.getInventory().getItem(0);
        ItemStack second = anvilEvent.getInventory().getItem(1);
        Object result = AnvilHandler.itemStackPresent(anvilEvent.getResult()) ? anvilEvent.getResult() : (this.isSingle(first) && this.isSingle(second) ? this.selectPrimaryItem(first, second, true).clone() : null);
        if (!AnvilHandler.itemStackPresent(result) || !this.isBook(first) && !this.isBook(second) && !first.getType().equals((Object)second.getType())) {
            return;
        }
        Map<MythicEnchant, Integer> enchantsF = this.enchantManager.getMythicEnchants(first);
        Map<MythicEnchant, Integer> enchantsS = this.enchantManager.getMythicEnchants(second);
        enchantsS.forEach((enchant, level) -> enchantsF.merge((MythicEnchant)enchant, (Integer)level, (i, j) -> i == j ? Math.min(enchant.getMaxLevel(), i + 1) : Math.max(i, j)));
        if (enchantsF.size() == 0) {
            return;
        }
        this.enchantManager.getMythicEnchants(this.selectPrimaryItem(first, second, true)).forEach((arg_0, arg_1) -> AnvilHandler.lambda$handleAnvilEvent$2((ItemStack)result, arg_0, arg_1));
        int mergeCost = 0;
        for (Map.Entry<MythicEnchant, Integer> entry : enchantsF.entrySet()) {
            MythicEnchant enchant2 = entry.getKey();
            int level2 = entry.getValue();
            if (!enchant2.getEnchantableMaterials().isEmpty() && !enchant2.getEnchantableMaterials().contains(result.getType()) && result.getType() != Material.ENCHANTED_BOOK) {
                anvilEvent.setResult(null);
                anvilEvent.getInventory().setRepairCost(9999);
                return;
            }
            if (!enchant2.getConflictingEnchants().isEmpty()) {
                boolean b = false;
                for (Enchantment ench : result.getEnchantments().keySet()) {
                    if (!enchant2.getConflictingEnchants().contains(ench.getName().toUpperCase())) continue;
                    b = true;
                }
                if (b) {
                    anvilEvent.setResult(null);
                    anvilEvent.getInventory().setRepairCost(9999);
                    return;
                }
            }
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Enchant: " + enchant2.getName() + " Level: " + level2), (Object[])new Object[0]);
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Enchant Display Name: " + enchant2.getDisplayName()), (Object[])new Object[0]);
            this.enchantManager.applyToItem((ItemStack)result, enchant2, level2);
            mergeCost += enchant2.getMergeCostPerLevel() * level2;
        }
        int fMergeCost = anvilEvent.getInventory().getRepairCost() + mergeCost;
        anvilEvent.setResult(result);
        anvilEvent.getInventory().setRepairCost(fMergeCost);
        Schedulers.sync().runLater(() -> AnvilHandler.lambda$handleAnvilEvent$3(anvilEvent, (ItemStack)result, fMergeCost), 1L);
    }

    private ItemStack selectPrimaryItem(ItemStack firstSlot, ItemStack secondSlot, boolean result) {
        return (!this.isBook(firstSlot) || this.isBook(secondSlot)) == result ? firstSlot : secondSlot;
    }

    private static /* synthetic */ void lambda$handleAnvilEvent$3(PrepareAnvilEvent anvilEvent, ItemStack result, int fMergeCost) {
        anvilEvent.setResult(result);
        anvilEvent.getInventory().setRepairCost(fMergeCost);
    }

    private static /* synthetic */ void lambda$handleAnvilEvent$2(ItemStack result, MythicEnchant enchant, Integer level) {
        enchant.removeLore(result, level);
    }
}

