/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.stations;

import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.stations.EnchantmentStationHandler;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public abstract class AbstractEnchantmentStationHandler
extends ReloadableModule<MythicEnchants>
implements EnchantmentStationHandler {
    protected final EnchantManager enchantManager;

    protected AbstractEnchantmentStationHandler(MythicEnchants mythicEnchants, EnchantManager enchantManager) {
        super((LuminePlugin)mythicEnchants, false);
        this.enchantManager = enchantManager;
        this.load(mythicEnchants);
    }

    public void load(MythicEnchants mythicEnchants) {
        this.subscribeHandlerEvents();
    }

    public void unload() {
    }

    protected boolean isBook(ItemStack item) {
        return !AbstractEnchantmentStationHandler.itemStackPresent(item) || item.getType() == Material.BOOK || item.getType() == Material.ENCHANTED_BOOK;
    }

    protected boolean isSingle(ItemStack itemToCheck) {
        return AbstractEnchantmentStationHandler.itemStackPresent(itemToCheck) && itemToCheck.getAmount() == 1;
    }

    protected static boolean itemStackPresent(ItemStack slotToCheck) {
        return slotToCheck != null && slotToCheck.getType() != Material.AIR;
    }

    protected abstract void subscribeHandlerEvents();
}

