/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.skills;

import com.google.common.collect.Lists;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractLocation;
import io.lumine.mythic.api.skills.IParentSkill;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillTrigger;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.utils.metadata.Pair;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillMechanic;
import io.lumine.mythic.core.skills.SkillMetadataImpl;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythic.core.skills.TriggeredSkill;
import io.lumine.mythic.core.skills.stats.StatModifierType;
import io.lumine.mythic.core.skills.stats.StatSource;
import io.lumine.mythic.core.skills.stats.StatType;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.enchants.custom.CustomEnchantment;
import io.lumine.mythicenchants.enchants.properties.EnchantSlot;
import io.lumine.mythicenchants.enchants.skills.SkillHolder;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Consumer;
import net.objecthunter.exp4j.Expression;
import org.bukkit.Material;

public class AppliedEnchant
implements SkillHolder,
StatSource {
    private final EnchantsProfile profile;
    private final Material item;
    private CustomEnchantment enchant;
    private int level;
    private EnchantSlot equippedSlot;
    private List<StatType> stats = Lists.newArrayList();
    private String trigger;

    public AppliedEnchant(EnchantsProfile profile, CustomEnchantment enchant, int level, EnchantSlot equippedSlot, Material item) {
        this.profile = profile;
        this.enchant = enchant;
        this.level = level;
        this.equippedSlot = equippedSlot;
        this.item = item;
        for (Map.Entry<String, Pair<Expression, StatModifierType>> statEntry : enchant.getStats().entrySet()) {
            String statName = statEntry.getKey();
            Optional maybeStat = MythicBukkit.inst().getStatManager().getStat(statName);
            if (maybeStat.isEmpty()) continue;
            StatType statType = (StatType)maybeStat.get();
            Pair<Expression, StatModifierType> valueEntry = statEntry.getValue();
            double value = ((Expression)valueEntry.getKey()).setVariable("L", (double)level).evaluate();
            profile.getPlayerData().getStatRegistry().putValueSilently(statType, (StatSource)this, (StatModifierType)valueEntry.getValue(), value);
            this.stats.add(statType);
        }
    }

    @Override
    public void runSkills(IParentSkill parentSkill, SkillMetadata data) {
        if (!this.enchant.hasMechanics(data.getCause())) {
            return;
        }
        SkillMetadata meta = data.deepClone();
        this.setVariables(meta);
        for (SkillMechanic mechanic : this.enchant.getMechanics(data.getCause())) {
            if (!mechanic.isUsableFromSkill(meta)) continue;
            mechanic.execute(meta);
        }
    }

    @Override
    public boolean runSkills(SkillCaster caster, SkillTrigger cause, AbstractLocation origin, AbstractEntity trigger, Consumer<SkillMetadata> transformer) {
        if (!this.enchant.hasMechanics(cause)) {
            return false;
        }
        TriggeredSkill ts = new TriggeredSkill(cause, caster, origin, trigger, this.enchant.getMechanics(cause), true, meta -> {
            this.setVariables((SkillMetadata)meta);
            if (transformer != null) {
                transformer.accept((SkillMetadata)meta);
            }
        });
        return ts.getCancelled();
    }

    @Override
    public boolean hasTimerSkills() {
        return this.enchant.hasTimerSkills();
    }

    @Override
    public void runTimerSkills(SkillCaster caster, long timer) {
        if (!caster.getEntity().asPlayer().isOnline()) {
            return;
        }
        SkillMetadataImpl data = new SkillMetadataImpl(SkillTriggers.TIMER, caster, null);
        this.setVariables((SkillMetadata)data);
        this.enchant.getTimerSkills().stream().forEach(arg_0 -> AppliedEnchant.lambda$runTimerSkills$1(timer, (SkillMetadata)data, arg_0));
    }

    @Override
    public Queue<SkillMechanic> getSkills(SkillTrigger cause) {
        return this.enchant.getMechanics(cause);
    }

    private void setVariables(SkillMetadata data) {
        if (this.trigger != null) {
            data.getVariables().putString("trigger-slot", EnchantSlot.getSlotName(this.trigger));
            this.trigger = null;
        } else if (data.getVariables().getString("trigger-slot") != null) {
            data.getVariables().putString("enchantment-trigger", "UNDEFINED");
        }
        data.getVariables().putString("enchant-name", this.enchant.getName());
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Enchantment level: " + data.getVariables().getInt("enchant-level")), (Object[])new Object[0]);
        data.getVariables().putInt("enchant-level", this.level);
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Enchantment level: " + data.getVariables().getInt("enchant-level")), (Object[])new Object[0]);
        data.getVariables().putString("enchant-slot", this.equippedSlot.toString());
    }

    public void setTrigger(String trigger) {
        this.trigger = trigger;
    }

    public List<StatType> getStats() {
        return this.stats;
    }

    private static /* synthetic */ void lambda$runTimerSkills$1(long timer, SkillMetadata data, SkillMechanic skill) {
        if ((double)timer % ((double)skill.getTimerInterval() / (double)MythicEnchants.inst().getConfiguration().getClockInterval()) != 0.0) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Skill {0} is not ready", (Object[])new Object[]{skill.getInternalName()});
            return;
        }
        if (!skill.usable(data)) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Skill {0} is not usable", (Object[])new Object[]{skill.getInternalName()});
            return;
        }
        skill.execute(data);
    }
}

