/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.properties;

import io.lumine.mythic.core.logging.MythicLogger;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public enum EnchantSlot {
    HEAD(EquipmentSlot.HEAD, player -> Optional.ofNullable(player.getInventory().getHelmet())),
    CHEST(EquipmentSlot.CHEST, player -> Optional.ofNullable(player.getInventory().getChestplate())),
    LEGS(EquipmentSlot.LEGS, player -> Optional.ofNullable(player.getInventory().getLeggings())),
    FEET(EquipmentSlot.FEET, player -> Optional.ofNullable(player.getInventory().getBoots())),
    HAND(EquipmentSlot.HAND, player -> Optional.ofNullable(player.getInventory().getItemInMainHand())),
    OFFHAND(EquipmentSlot.OFF_HAND, player -> Optional.ofNullable(player.getInventory().getItemInOffHand()));

    private EquipmentSlot equipmentSlot;
    private Function<Player, Optional<ItemStack>> funcGetItem;

    private EnchantSlot(EquipmentSlot equipmentSlot, Function<Player, Optional<ItemStack>> funcGetItem) {
        this.equipmentSlot = equipmentSlot;
        this.funcGetItem = funcGetItem;
    }

    public int getEnchantLevel(Player player, Enchantment enchant) {
        Optional<ItemStack> maybeItem = this.funcGetItem.apply(player);
        if (!maybeItem.isPresent()) {
            return 0;
        }
        return maybeItem.get().getEnchantmentLevel(enchant);
    }

    public Optional<ItemStack> getItem(Player player) {
        return this.funcGetItem.apply(player);
    }

    public EquipmentSlot toEquipmentSlot() {
        return this.equipmentSlot;
    }

    public static String getSlotName(String armorName) {
        return EnchantSlot.determineSlotName(armorName);
    }

    public static EnchantSlot getSlot(String armorName) {
        return EnchantSlot.valueOf(EnchantSlot.determineSlotName(armorName));
    }

    private static String determineSlotName(String armorName) {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Armor Name: " + armorName), (Object[])new Object[0]);
        String armorNameFormatted = armorName.replace(" ", "_");
        String armorType = armorNameFormatted.substring(armorNameFormatted.indexOf("_") + 1).replace("[", "").replace("]", "").toUpperCase();
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("Armor Type to check: " + armorType), (Object[])new Object[0]);
        switch (armorType) {
            case "HELMET": {
                return "HEAD";
            }
            case "CHESTPLATE": {
                return "CHEST";
            }
            case "LEGGINGS": {
                return "LEGS";
            }
            case "BOOTS": {
                return "FEET";
            }
        }
        return "UNDEFINED";
    }
}

