/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.loot.handlers;

import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.loot.handlers.LootEventHandler;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;

public class VillagerAcquireHandler
implements LootEventHandler {
    private final EnchantManager enchantManager;
    private MythicEnchant enchantment;
    private final VillagerAcquireTradeEvent tradeEvent;
    private ItemStack enchantedItem;

    public VillagerAcquireHandler(VillagerAcquireTradeEvent tradeEvent, EnchantManager enchantManager) {
        this.tradeEvent = tradeEvent;
        this.enchantManager = enchantManager;
    }

    @Override
    public void addEnchantedItem() {
        this.tradeEvent.setRecipe(this.createRecipe());
    }

    @Override
    public boolean requirementsMet() {
        Material resultType = this.tradeEvent.getRecipe().getResult().getType();
        AbstractVillager abstractVillager = this.tradeEvent.getEntity();
        if (!(abstractVillager instanceof Villager)) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"VillagerAcquireHandler: Entity is not is villager!", (Object[])new Object[0]);
            return false;
        }
        Villager villager = (Villager)abstractVillager;
        if (!this.enchantment.getRarityCategory().getChanceVillagers().containsKey(villager.getProfession())) {
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("VillagerAcquireHandler: Rarity " + this.enchantment.getRarityCategory().getDisplay() + " does not contain a chance value for this profession " + String.valueOf(villager.getProfession()) + "!"), (Object[])new Object[0]);
            return false;
        }
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("VillagerAcquireHandler: Is item " + String.valueOf(this.tradeEvent.getRecipe().getResult().getType().getKey()) + " an EnchantableMaterial? (" + (this.enchantment.getEnchantableMaterials().contains(resultType) || resultType == Material.ENCHANTED_BOOK) + ")"), (Object[])new Object[0]);
        return this.enchantment.getEnchantableMaterials().contains(resultType) || resultType == Material.ENCHANTED_BOOK;
    }

    @Override
    public double getLootChance() {
        Villager.Profession tradeProfession = ((Villager)this.tradeEvent.getEntity()).getProfession();
        return this.enchantment.getRarityCategory().getChanceVillagers().get(tradeProfession);
    }

    @Override
    public void setEnchantedLoot(MythicEnchant enchantment, int appliedLevel, Random randomIntGenerator) {
        this.enchantment = enchantment;
        this.enchantedItem = this.setEnchantedItem();
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("VillagerAcquireHandler: Possible Item Set (" + String.valueOf(this.enchantedItem.getType()) + "(" + this.enchantment.getPropertyNode() + "))"), (Object[])new Object[0]);
    }

    @Override
    public String getEventName() {
        return this.tradeEvent.getEventName();
    }

    private ItemStack setEnchantedItem() {
        ItemStack baseItem = new ItemStack(this.tradeEvent.getRecipe().getResult().getType());
        return this.enchantManager.applyToItem(baseItem, this.enchantment, 1);
    }

    private MerchantRecipe createRecipe() {
        MerchantRecipe initialRecipe = this.tradeEvent.getRecipe();
        MerchantRecipe newRecipe = new MerchantRecipe(this.enchantedItem, 0, 3, initialRecipe.hasExperienceReward(), initialRecipe.getVillagerExperience(), initialRecipe.getPriceMultiplier(), initialRecipe.getDemand(), initialRecipe.getSpecialPrice());
        newRecipe.setIngredients(initialRecipe.getIngredients());
        return newRecipe;
    }
}

