/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.loot;

import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.plugin.LuminePlugin;
import io.lumine.mythic.bukkit.utils.plugin.ReloadableModule;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.enchants.EnchantManager;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.loot.handlers.LootEventHandler;
import io.lumine.mythicenchants.enchants.loot.handlers.LootGenerateHandler;
import io.lumine.mythicenchants.enchants.loot.handlers.VillagerAcquireHandler;
import java.util.List;
import java.util.Random;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.world.LootGenerateEvent;

public class LootEventManager
extends ReloadableModule<MythicEnchants> {
    private final EnchantManager enchantManager;
    private final Random random = new Random();

    public LootEventManager(MythicEnchants plugin, EnchantManager enchantManager) {
        super((LuminePlugin)plugin, false);
        this.enchantManager = enchantManager;
        this.load(plugin);
    }

    public void load(MythicEnchants mythicEnchants) {
        Events.subscribe(LootGenerateEvent.class).handler(event -> {
            LootGenerateHandler lootGenerateHandler = new LootGenerateHandler((LootGenerateEvent)event, this.enchantManager);
            this.manageHandler(lootGenerateHandler);
        }).bindWith((TerminableConsumer)this);
        Events.subscribe(VillagerAcquireTradeEvent.class).handler(event -> {
            VillagerAcquireHandler villagerAcquireHandler = new VillagerAcquireHandler((VillagerAcquireTradeEvent)event, this.enchantManager);
            this.manageHandler(villagerAcquireHandler);
        }).bindWith((TerminableConsumer)this);
    }

    public void unload() {
    }

    private void manageHandler(LootEventHandler handler) {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("LootEventManager: " + handler.getEventName() + " Being handled"), (Object[])new Object[0]);
        MythicEnchant selectedEnchant = this.getLootEnchantment();
        handler.setEnchantedLoot(selectedEnchant, this.determineEnchantmentLootLevel(selectedEnchant), this.random);
        if (!handler.requirementsMet()) {
            return;
        }
        if (!this.lootRoll(handler.getLootChance())) {
            return;
        }
        handler.addEnchantedItem();
    }

    private MythicEnchant getLootEnchantment() {
        List<MythicEnchant> filteredEnchantments = this.enchantManager.getEnchantments().values().stream().filter(mythicEnchant -> mythicEnchant.getRarityCategory() != null).toList();
        return filteredEnchantments.get(this.random.nextInt(filteredEnchantments.size()));
    }

    private boolean lootRoll(double chance) {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)("LootEventManager: Rolling loot with chance: " + chance + "%"), (Object[])new Object[0]);
        return (double)(this.random.nextInt(100) + 1) <= chance;
    }

    private int determineEnchantmentLootLevel(MythicEnchant enchantment) {
        return this.random.nextInt(enchantment.getMaxLevel()) + 1;
    }
}

