/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.listeners;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.utils.Events;
import io.lumine.mythic.bukkit.utils.Schedulers;
import io.lumine.mythic.bukkit.utils.events.extra.ArmorEquipEvent;
import io.lumine.mythic.bukkit.utils.logging.Log;
import io.lumine.mythic.bukkit.utils.terminable.TerminableConsumer;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.SkillTriggers;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.enchants.MythicEnchant;
import io.lumine.mythicenchants.enchants.hardcoded.HardcodedEnchantment;
import io.lumine.mythicenchants.enchants.listeners.EnchantListener;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import io.lumine.mythicenchants.profiles.EnchantsProfileManager;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;

public class SpigotEnchantListener
extends EnchantListener {
    private ArmorEquipEvent previousEvent;

    public SpigotEnchantListener(MythicEnchants mythicEnchants, EnchantsProfileManager enchantsProfileManager) {
        super(mythicEnchants, enchantsProfileManager);
        this.load(mythicEnchants);
    }

    public void load(MythicEnchants plugin) {
        Log.info((String)"Loading SpigotEnchantListener...");
        Events.subscribe(ArmorEquipEvent.class, (EventPriority)EventPriority.MONITOR).handler(event -> {
            HardcodedEnchantment hardcodedEnchantment;
            MythicEnchant patt0$temp;
            Optional<MythicEnchant> maybeMythicEnchant;
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Armor triggered via spigot listener event.", (Object[])new Object[0]);
            this.recordEventInfo((ArmorEquipEvent)event);
            if (this.previousEvent != null && this.previousEvent.equals(event)) {
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"ArmorEquipEvent: {0} is a duplicate event.", (Object[])new Object[]{event.hashCode()});
                return;
            }
            MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"ArmorEquipEvent: {0} is not a duplicate event.", (Object[])new Object[]{event.hashCode()});
            this.previousEvent = event;
            Player player = event.getPlayer();
            EnchantsProfile profile = (EnchantsProfile)this.getManager().getProfile(player);
            if (event.getMethod() == ArmorEquipEvent.EquipMethod.SHIFT_CLICK) {
                profile.parseEquipment();
            }
            if (event.getOldArmorPiece() != null && event.getOldArmorPiece().getType() != Material.AIR) {
                for (Map.Entry entry : event.getOldArmorPiece().getEnchantments().entrySet()) {
                    maybeMythicEnchant = ((MythicEnchants)this.getPlugin()).getEnchantManager().toMythicEnchantment((Enchantment)entry.getKey());
                    if (!maybeMythicEnchant.isPresent() || !((patt0$temp = maybeMythicEnchant.get()) instanceof HardcodedEnchantment)) continue;
                    hardcodedEnchantment = (HardcodedEnchantment)patt0$temp;
                    Schedulers.sync().runLater(() -> hardcodedEnchantment.onUnequip(player, (Integer)entry.getValue()), 1L);
                }
                MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"Unequip triggered via spigot listener event.", (Object[])new Object[0]);
                profile.parseEquipment();
                profile.runSkills(SkillTriggers.ARMOR_UNEQUIP, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
            }
            if (event.getNewArmorPiece() != null && event.getNewArmorPiece().getType() != Material.AIR) {
                for (Map.Entry entry : event.getNewArmorPiece().getEnchantments().entrySet()) {
                    maybeMythicEnchant = ((MythicEnchants)this.getPlugin()).getEnchantManager().toMythicEnchantment((Enchantment)entry.getKey());
                    if (!maybeMythicEnchant.isPresent() || !((patt0$temp = maybeMythicEnchant.get()) instanceof HardcodedEnchantment)) continue;
                    hardcodedEnchantment = (HardcodedEnchantment)patt0$temp;
                    Schedulers.sync().runLater(() -> hardcodedEnchantment.onEquip(player, (Integer)entry.getValue()), 1L);
                }
                Schedulers.sync().runLater(() -> {
                    profile.parseEquipment();
                    profile.runSkills(SkillTriggers.ARMOR_EQUIP, (AbstractEntity)BukkitAdapter.adapt((Player)event.getPlayer()));
                }, 1L);
            }
        }).bindWith((TerminableConsumer)this);
    }

    public void recordEventInfo(ArmorEquipEvent event) {
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"ArmorEquipEvent: {0} name: {1}", (Object[])new Object[]{event.hashCode(), event.getPlayer().getName()});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"ArmorEquipEvent: {0} old armor: {1}", (Object[])new Object[]{event.hashCode(), event.getOldArmorPiece()});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"ArmorEquipEvent: {0} new armor: {1}", (Object[])new Object[]{event.hashCode(), event.getNewArmorPiece()});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"ArmorEquipEvent: {0} method: {1}", (Object[])new Object[]{event.hashCode(), event.getMethod()});
        MythicLogger.debug((MythicLogger.DebugLevel)MythicLogger.DebugLevel.INFO, (String)"ArmorEquipEvent: {0} slot: {1}", (Object[])new Object[]{event.hashCode(), event.getType()});
    }

    public void unload() {
    }
}

