/*
 * Decompiled with CFR 0.152.
 */
package io.lumine.mythicenchants.enchants.custom.mechanics;

import io.lumine.mythic.api.config.MythicLineConfig;
import io.lumine.mythic.api.skills.INoTargetSkill;
import io.lumine.mythic.api.skills.SkillMetadata;
import io.lumine.mythic.api.skills.SkillResult;
import io.lumine.mythic.api.skills.placeholders.PlaceholderInt;
import io.lumine.mythic.api.skills.placeholders.PlaceholderString;
import io.lumine.mythic.core.logging.MythicLogger;
import io.lumine.mythic.core.skills.placeholders.PlaceholderMeta;
import io.lumine.mythicenchants.MythicEnchants;
import io.lumine.mythicenchants.profiles.EnchantsProfile;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EnchantItemMechanic
implements INoTargetSkill {
    private PlaceholderString enchantment;
    private PlaceholderInt level;

    public EnchantItemMechanic(MythicLineConfig lineConfig) {
        this.enchantment = lineConfig.getPlaceholderString(new String[]{"enchantment", "enchant", "ench", "e"}, "SHARPNESS", new String[0]);
        this.level = lineConfig.getPlaceholderInteger(new String[]{"level", "l"}, 1, new String[0]);
    }

    public SkillResult cast(SkillMetadata data) {
        if (!data.getCaster().getEntity().isPlayer()) {
            return SkillResult.INVALID_TARGET;
        }
        if (data.getVariables().has("equip-item")) {
            ItemStack item = (ItemStack)data.getVariables().get("equip-item").get();
            String enchant = this.enchantment.get((PlaceholderMeta)data);
            int level = this.level.get((PlaceholderMeta)data);
            if (!MythicEnchants.inst().getEnchantManager().applyEnchantment(item, enchant, level)) {
                MythicLogger.error((String)("Enchantment " + enchant + " doesnt exist"));
            }
            ((EnchantsProfile)MythicEnchants.inst().getProfileManager().getProfile((Player)data.getCaster().getEntity().getBukkitEntity())).parseEquipment();
        }
        return SkillResult.SUCCESS;
    }
}

